/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Date;
import type.lang.IO;
import type.lang.UniReader;

public class Stock
implements Serializable {
    private String ticker = null;
    private double price = 0.0;
    private static final double TPi = Math.PI * 2;
    private static final int MAX = 675;
    private static final long YEAR = 31536000L;
    private static final String[] PA = new String[]{"ALPHA", "BRAVO", "CHARLIE", "DELTA", "ECHO", "FOXTROT", "GOLF", "HOTEL", "INDIA", "JULIET", "KILO", "LIMA", "MIKE", "NOVEMBER", "OSCAR", "PAPA", "QUEBEC", "ROMEO", "SIERRA", "TANGO", "UNIFORM", "VICTOR", "WHISKEY", "X-RAY", "YANKEE", "ZULU"};
    public String name = null;
    public char delimiter = (char)32;
    public static boolean titleCaseName = false;
    public static final String TSE_URL = "http://www.tse.com/HttpController?GetPage=QuotesViewPage&DetailedView=DetailedPrices&Language=en&QuoteSymbol_1=";
    private static final String NAME_KEYWORD = "Instrument<BR>Name:</TD>";
    private static final String PRICE_KEYWORD = ">Last Traded<";
    private static final String NOT_FOUND_KEYWORD = "The following invalid symbols were found:";

    public Stock() {
        this(null);
    }

    public Stock(String string) {
        IO.format("Stock", "1hamzeh0");
        this.setSymbol(string);
    }

    public String getName() {
        if (this.name != null & titleCaseName) {
            String string = "";
            for (int i = this.name.length() - 1; i > 0; --i) {
                char c = this.name.charAt(i);
                if (Character.isLetter(c) && Character.isLetter(this.name.charAt(i - 1))) {
                    c = Character.toLowerCase(c);
                }
                string = c + string;
            }
            return this.name.charAt(0) + string;
        }
        return this.name;
    }

    public String getSymbol() {
        return this.ticker;
    }

    public double getPrice() {
        return this.price;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public boolean setDelimiter(char c) {
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        this.delimiter = c;
        return true;
    }

    public void setSymbol(String string) {
        this.ticker = string;
        if (this.ticker != null) {
            this.ticker = this.ticker.toUpperCase();
        }
        this.refresh();
    }

    public String toString() {
        if (this.name == null) {
            return "No such stock!";
        }
        return this.ticker + this.delimiter + this.name;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Stock && ((Stock)object).getSymbol().equals(this.ticker);
    }

    public void refresh() {
        this.name = null;
        this.price = 0.0;
        if (this.ticker == null) {
            return;
        }
        if (this.ticker.indexOf("HR.") == 0) {
            this.fake();
            return;
        }
        if (this.ticker.indexOf(".") == 0) {
            this.simulate();
            return;
        }
        UniReader uniReader = new UniReader(TSE_URL + this.ticker);
        String string = uniReader.readLine();
        while (!uniReader.eof()) {
            int n;
            int n2;
            int n3 = string.indexOf(NAME_KEYWORD);
            if (n3 != -1 && (n2 = (string = uniReader.readLine()).indexOf(">")) < (n = string.indexOf("<", n2 + 1))) {
                this.name = string.substring(n2 + 1, n);
            }
            if (string.indexOf(PRICE_KEYWORD) != -1 && (n2 = (string = uniReader.readLine()).indexOf(">")) < (n = string.indexOf("<", n2 + 1))) {
                this.price = Double.parseDouble(string.substring(n2 + 1, n));
                break;
            }
            if (string.indexOf(NOT_FOUND_KEYWORD) != -1) {
                this.price = 0.0;
                break;
            }
            string = uniReader.readLine();
        }
        uniReader.close();
    }

    public Stock cloneMe() {
        Stock stock = new Stock();
        stock.ticker = this.ticker;
        stock.price = this.price;
        stock.name = this.name;
        stock.delimiter = this.delimiter;
        return stock;
    }

    private void fake() {
        String string = this.ticker.substring(3, 4);
        int n = string.compareTo("A") + 1;
        this.name = n % 2 == 0 ? string + "TECH INC." : string + "COMP CORP";
        this.price = (double)n + (double)n / 100.0;
        if (n < 1 || n > 26) {
            this.name = null;
            this.price = 0.0;
        }
    }

    private void simulate() {
        int n;
        this.name = null;
        this.price = 0.0;
        if (this.ticker.length() != 3) {
            return;
        }
        int n2 = this.ticker.toUpperCase().charAt(1) - 65;
        int n3 = 26 * n2 + (n = this.ticker.toUpperCase().charAt(2) - 65);
        if (n3 < 0 || n3 > 675) {
            return;
        }
        Date date = new Date();
        long l = date.getTime() / 1000L;
        double d = ((double)n3 - 337.5) / 337.5;
        d = 100.0 * d * d;
        double d2 = Math.PI * 2 * (double)n3 / 675.0;
        double d3 = (double)(l -= 1072224000L) / 3.1536E7;
        double d4 = 0.05 * Math.sin(Math.PI * 2 * (double)l / 60.0);
        double d5 = Math.sin(Math.PI * 2 * (double)l / 3.1536E7 + d2);
        this.price = (1.0 + d5) * d + d4 + d3;
        this.price = Double.parseDouble(IO.format(this.price, ".2"));
        int n4 = n3 % 6;
        this.name = n4 == 0 ? "The " + PA[n2] + " " + PA[n] + " Corporation" : (n4 == 1 ? PA[n2] + " of " + PA[n] + " Company" : (n4 == 2 ? PA[n2] + "-Tech and " + PA[n] + " Co." : (n4 == 3 ? PA[n2] + " " + PA[n] + " Ltd." : (n4 == 4 ? PA[n2] + "-" + PA[n] + " Inc." : "Compu-" + PA[n2] + " & " + PA[n] + " Corp."))));
    }
}

