/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.io.InputStream;
import java.util.StringTokenizer;
import type.uc.CheckNoMoreInputException;
import type.uc.Terminal;

class TermInpStream
extends InputStream {
    Terminal term;
    String buffer;
    int position;
    boolean redirect;
    StringTokenizer stk;

    TermInpStream(Terminal terminal) {
        this.term = terminal;
        this.buffer = "";
        this.position = -1;
        this.redirect = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int read() {
        this.term.tos.realFlush();
        if (this.position == this.buffer.length()) {
            this.position = -1;
            return -1;
        }
        if (this.position == -1) {
            if (this.redirect) {
                if (!this.stk.hasMoreTokens()) {
                    this.revert();
                    throw new CheckNoMoreInputException();
                }
                this.buffer = this.stk.nextToken();
            } else {
                this.buffer = this.term.read();
            }
            this.position = 0;
        }
        char c = this.buffer.charAt(this.position);
        ++this.position;
        return c;
    }

    void inhibit(String string) {
        if (this.redirect || string == null || string.length() < 1) {
            return;
        }
        this.redirect = true;
        this.stk = new StringTokenizer(string, "\n", true);
        this.position = -1;
    }

    boolean revert() {
        if (!this.redirect) {
            return false;
        }
        this.redirect = false;
        return this.stk.hasMoreTokens();
    }
}

