/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.util.Random;
import type.lang.IO;
import type.lang.SE;
import type.lib.Fraction;

public class MixedNumber
extends Fraction {
    private static Random rng = new Random();

    public MixedNumber() {
        this(1, 0L, 0L, 1L);
    }

    public MixedNumber(int n, long l, long l2, long l3) {
        super((long)n * (l2 + l * l3), l3);
        SE.require(Math.abs(n) == 1, "Sign must be + or -1");
        SE.require(l >= 0L, "Whole part must be non-negative!");
        SE.require(l2 >= 0L, "Numerator must be non-negative!");
        SE.require(l3 >= 0L, "Denominator must be non-negative!");
        IO.format("MixedNumber", "1hamzeh0");
    }

    public int getSign() {
        if (super.getNumerator() < 0L) {
            return -1;
        }
        return 1;
    }

    public long getWhole() {
        return Math.abs(super.getNumerator()) / this.getDenominator();
    }

    public long getProperNumerator() {
        return Math.abs(super.getNumerator()) % this.getDenominator();
    }

    public long getProperDenominator() {
        return super.getDenominator();
    }

    public String toString() {
        if (this.getProperDenominator() == 0L) {
            return "NaMN";
        }
        String string = "+";
        if (this.getSign() == -1) {
            string = "-";
        }
        return string + " " + this.getWhole() + " " + this.getProperNumerator() + "/" + this.getProperDenominator();
    }

    public boolean resembles(MixedNumber mixedNumber) {
        if (mixedNumber == null) {
            return false;
        }
        return this.getWhole() == mixedNumber.getWhole();
    }

    public static Fraction getRandom() {
        if (rng.nextInt(2) == 0) {
            return new MixedNumber(1 - 2 * rng.nextInt(2), rng.nextInt(1000), rng.nextInt(1000), 1 + rng.nextInt(1000));
        }
        return Fraction.getRandom();
    }
}

