/*
 * Decompiled with CFR 0.152.
 */
package type.ec;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import type.lang.IO;
import type.lang.UniReader;
import type.lang.UniWriter;

public class Options {
    public static final String VERSION = "5A";
    public static final String SLASH = System.getProperty("file.separator");
    public static final String HOME = System.getProperty("user.home");
    private static String[] data = null;
    private JDialog jd;
    private JButton button;
    private JButton cancel;
    private JTextField login;
    private JTextField ecURL;
    private JPasswordField pswrd;
    private JCheckBox chkBox;

    public Options() {
        if (data == null) {
            data = new String[8];
            Options.getCookie();
        }
    }

    public String getStartup() {
        return data[5];
    }

    public void setStartup(String string) {
        Options.data[5] = string;
        Options.setCookie();
    }

    String[] getOptions() {
        return data;
    }

    void setOptions(String[] stringArray) {
        data = stringArray;
        Options.setCookie();
    }

    private static void getCookie() {
        Options.data[0] = "0";
        Options.data[1] = "";
        Options.data[2] = "";
        Options.data[3] = "9999";
        Options.data[4] = "URL of eCheck server (if available)";
        Options.data[5] = HOME;
        Options.data[7] = "T";
        UniReader uniReader = null;
        try {
            uniReader = new UniReader(HOME + SLASH + ".UCrc");
            String string = uniReader.readLine();
            string = IO.format(string, "2hamzeh3");
            Options.data[0] = string.substring(0, 4);
            Options.data[3] = string.substring(4, 8);
            int n = Integer.parseInt(string.substring(8, 10));
            Options.data[1] = string.substring(12, 12 + n);
            int n2 = Integer.parseInt(string.substring(10, 12));
            Options.data[2] = string.substring(12 + n, 12 + n + n2);
            string = uniReader.readLine();
            if (!uniReader.eof() && string != null && string.trim().length() > 9) {
                Options.data[4] = string.trim();
            }
            string = uniReader.readLine();
            if (!uniReader.eof() && string != null && string.trim().length() > 0) {
                Options.data[5] = string.trim();
            }
            string = uniReader.readLine();
            if (!uniReader.eof() && string != null && string.trim().length() > 0) {
                Options.data[7] = string.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uniReader != null) {
            uniReader.close();
        }
        Options.setPacket();
    }

    private static void setCookie() {
        Options.setPacket();
        UniWriter uniWriter = new UniWriter(HOME + SLASH + ".UCrc");
        uniWriter.println(IO.format(IO.format(data[0].trim(), "4Z") + IO.format(data[3].trim(), "4Z") + data[6], "2hamzeh2"));
        uniWriter.println(data[4]);
        uniWriter.println(data[5]);
        uniWriter.println(data[7]);
        uniWriter.close();
    }

    private static void setPacket() {
        Options.data[6] = IO.format(data[1].length(), "2Z") + IO.format(data[2].length(), "2Z") + data[1] + data[2];
    }

    public static void main(String[] stringArray) {
        new Options().action(null);
        System.exit(0);
    }

    public void action(JFrame jFrame) {
        Options.getCookie();
        this.jd = new JDialog(jFrame, "Options /version 5A", true);
        Container container = this.jd.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        boolean bl = data[7].equals("T");
        this.chkBox = new JCheckBox(" Work Offline (no marks will be recorded)", bl);
        this.chkBox.setHorizontalAlignment(0);
        jPanel.add(this.chkBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel = new JLabel("Login ID");
        jLabel.setAlignmentX(0.5f);
        jPanel2.add(jLabel);
        this.login = new JTextField(data[1], 10);
        this.login.setFont(new Font("Monospaced", 0, 14));
        this.login.setForeground(Color.BLUE);
        jPanel2.add(this.login);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 20)));
        jLabel = new JLabel("Password");
        jLabel.setAlignmentX(0.5f);
        jPanel2.add(jLabel);
        this.pswrd = new JPasswordField(data[2], 10);
        this.pswrd.setFont(new Font("Monospaced", 0, 14));
        this.pswrd.setForeground(Color.BLUE);
        jPanel2.add(this.pswrd);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 20)));
        jLabel = new JLabel("eCheck URL");
        jLabel.setAlignmentX(0.5f);
        jPanel2.add(jLabel);
        this.ecURL = new JTextField(data[4], 35);
        this.ecURL.setFont(new Font("Monospaced", 0, 14));
        this.ecURL.setForeground(Color.BLUE);
        jPanel2.add(this.ecURL);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 20)));
        this.button = new JButton("Apply");
        this.cancel = new JButton("Cancel");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.cancel);
        jPanel3.add(Box.createRigidArea(new Dimension(50, 0)));
        jPanel3.add(this.button);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 20)));
        container.add(jPanel);
        container.add(Box.createRigidArea(new Dimension(0, 20)));
        container.add(jPanel2);
        this.jd.setDefaultCloseOperation(2);
        this.enableInput(!data[7].equals("T"));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                data[1] = Options.this.login.getText();
                data[2] = new String(Options.this.pswrd.getPassword());
                data[4] = Options.this.ecURL.getText().trim();
                data[7] = Options.this.chkBox.isSelected() ? "T" : "F";
                Options.setCookie();
                Options.this.jd.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Options.this.jd.dispose();
            }
        });
        this.chkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Options.this.enableInput(!Options.this.chkBox.isSelected());
            }
        });
        this.jd.pack();
        this.jd.setLocationRelativeTo(jFrame);
        this.jd.show();
    }

    private void enableInput(boolean bl) {
        this.login.setEnabled(bl);
        this.ecURL.setEnabled(bl);
        this.pswrd.setEnabled(bl);
    }

    public static boolean isValidLabNo(String string) {
        boolean bl = false;
        if (string != null && string.length() == 3 && "0123456789".indexOf(string.charAt(0)) != -1 && "0123456789".indexOf(string.charAt(1)) != -1 && "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(string.charAt(2)) != -1) {
            bl = true;
        }
        return bl;
    }
}

