/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import type.lang.IO;
import type.lib.Fraction;
import type.lib.MixedNumber;

public class Money
extends MixedNumber {
    private static final long serialVersionUID = 1L;

    public Money() {
        this(1, 1L, 0L);
    }

    public Money(Money money) {
        this(money.getSign(), money.getDollar(), money.getCent());
    }

    public Money(double m) {
        this(Money.signOf(m), Money.dollarOf(m), Money.centOf(m));
    }

    public Money(int s, long d, long c) {
        super(s, d + c / 100L, c % 100L, 100L);
    }

    public long getDollar() {
        return super.getWhole();
    }

    public long getCent() {
        return this.getProperNumerator() * 100L / super.getProperDenominator();
    }

    @Override
    public String toString() {
        if (super.getProperDenominator() == 0L) {
            return "NaM";
        }
        String sgn = "";
        if (this.getSign() == -1) {
            sgn = "(minus) ";
        }
        return String.valueOf(sgn) + "$" + IO.format(this.getDollar(), ",") + " dollars and " + this.getCent() + " cents.";
    }

    private static int signOf(double x) {
        if (x < 0.0) {
            return -1;
        }
        return 1;
    }

    private static long dollarOf(double x) {
        String tmp = IO.format(x, ".2");
        int point = tmp.indexOf(".");
        return Math.abs(Long.parseLong(tmp.substring(0, point)));
    }

    private static long centOf(double x) {
        String tmp = IO.format(x, ".2");
        int point = tmp.indexOf(".");
        return Long.parseLong(tmp.substring(point + 1, point + 3));
    }

    public boolean resembles(Money other) {
        if (other == null) {
            return false;
        }
        return this.getCent() / 25L == other.getCent() / 25L;
    }

    public static Fraction getRandom() {
        if (rng.nextInt(2) == 0) {
            return new Money(1000.0 + rng.nextDouble() * 2000.0);
        }
        return MixedNumber.getRandom();
    }
}

