/*
 * Decompiled with CFR 0.152.
 */
package type.lang;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import type.lang.IO;

public class UniWriter {
    private static final String EOL = System.getProperty("line.separator");
    private String descriptor;
    private String theTarget;
    private PrintWriter handle;

    public UniWriter(String target, boolean append) {
        try {
            if (target == null) {
                this.handle = new PrintWriter(System.out);
                this.descriptor = "Standard Output";
            } else {
                if (!new File(target).isAbsolute()) {
                    target = String.valueOf(IO.workingDir) + File.separator + target;
                }
                this.handle = new PrintWriter(new FileOutputStream(target, append));
                this.descriptor = "the file " + target;
            }
            this.theTarget = target;
        }
        catch (IOException e) {
            throw new RuntimeException("File cannot be opened for writing!");
        }
    }

    public UniWriter(String target) {
        this(target, false);
    }

    public UniWriter() {
        this(null);
    }

    public String toString() {
        return "A UniWriter connected to " + this.descriptor;
    }

    public void close() {
        if (this.theTarget == null) {
            return;
        }
        this.handle.close();
    }

    public void println() {
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(char value) {
        this.handle.print("" + value);
        this.handle.flush();
    }

    public void println(char value) {
        this.print(value);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(long value) {
        this.handle.print("" + value);
        this.handle.flush();
    }

    public void println(long value) {
        this.print(value);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(double value) {
        this.handle.print("" + value);
        this.handle.flush();
    }

    public void println(double value) {
        this.print(value);
        this.print(EOL);
        this.handle.flush();
    }

    public void print(boolean value) {
        if (value) {
            this.handle.print("true");
            this.handle.flush();
        } else {
            this.handle.print("false");
            this.handle.flush();
        }
    }

    public void println(boolean value) {
        this.print(value);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(Object value) {
        if (value == null) {
            this.handle.print("<null>");
        } else {
            this.handle.print(value.toString());
        }
        this.handle.flush();
    }

    public void println(Object value) {
        this.print(value);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(byte value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(byte value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(short value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(short value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(char value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(char value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(int value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(int value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(long value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(long value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(float value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(float value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(double value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(double value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(boolean value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(boolean value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(Object value, String fd) {
        this.handle.print(IO.format(value, fd));
        this.handle.flush();
    }

    public void println(Object value, String fd) {
        this.print(value, fd);
        this.handle.print(EOL);
        this.handle.flush();
    }
}

