/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import type.uc.Terminal;

class TermDoc
extends DefaultStyledDocument {
    private Terminal term;
    private int mode = 0;
    private AttributeSet[] attribute = new AttributeSet[5];
    private int mark;
    private static final long serialVersionUID = 1L;

    TermDoc() {
        SimpleAttributeSet sas = new SimpleAttributeSet();
        StyleConstants.setForeground(sas, Color.green.darker());
        StyleConstants.setBold(sas, true);
        this.attribute[0] = sas;
        this.attribute[3] = sas;
        sas = new SimpleAttributeSet();
        StyleConstants.setForeground(sas, Color.black);
        StyleConstants.setItalic(sas, true);
        StyleConstants.setBold(sas, true);
        this.attribute[1] = sas;
        sas = new SimpleAttributeSet();
        StyleConstants.setForeground(sas, Color.blue);
        StyleConstants.setItalic(sas, false);
        this.attribute[2] = sas;
        sas = new SimpleAttributeSet();
        StyleConstants.setForeground(sas, Color.red);
        this.attribute[4] = sas;
    }

    void setTerminal(Terminal t) {
        this.term = t;
    }

    void setMode(int m) {
        this.mode = m;
        this.mark = this.getEndPosition().getOffset() - 1;
    }

    @Override
    public void insertString(int offset, String s, AttributeSet a) throws BadLocationException {
        if (this.mode > 1 || s == null) {
            return;
        }
        int end = s.indexOf("\n");
        super.insertString(this.getEndPosition().getOffset() - 1, s, this.attribute[Math.abs(this.mode)]);
        try {
            if (end != -1 && this.mode >= 0) {
                this.term.entry = this.getText(this.mark, this.getEndPosition().getOffset() - this.mark - 1);
                if (this.mode == 0) {
                    this.term.exec();
                } else {
                    this.mode = 2;
                }
            }
            this.term.setCaretPosition(this.getEndPosition().getOffset() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void print(String s, int m) {
        if (m <= 1) {
            return;
        }
        this.mode = -m;
        try {
            this.insertString(1, s, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mode = m;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.mode > 1) {
            return;
        }
        if (this.mode == -99) {
            super.remove(offs, len);
        }
        if (this.getEndPosition().getOffset() == offs + 2 && offs >= this.mark) {
            super.remove(offs, len);
        }
    }
}

