/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import type.lang.IO;
import type.lib.CEstudent;
import type.lib.ITstudent;
import type.lib.SEstudent;
import type.lib.ToolBox;

public class Student
implements Serializable,
Iterable<String> {
    protected static Random rng = new Random();
    private static Student lastST = null;
    private String id;
    private String name;
    private String record;
    private static final String DIGITS = "0123456789";
    private static final String GRADES = "ABCDEFabcdef";
    private int start;
    private static final long serialVersionUID = 1L;

    public Student(String id, String name) {
        ToolBox.crash(!this.isDigit(id) || id.length() != 9, "Invalid ID!");
        this.id = id;
        this.name = name;
        this.record = "";
        IO.format("Student", "1hamzeh0");
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<String> iterator() {
        Iterator<String> iterator = new Iterator<String>(){
            private int start = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String next() {
                if (this.start >= Student.this.record.length()) {
                    throw new NoSuchElementException();
                }
                String next = Student.this.record.substring(this.start, this.start + 4);
                this.start += 5;
                return next;
            }

            @Override
            public boolean hasNext() {
                return this.start < Student.this.record.length();
            }
        };
        return iterator;
    }

    @Deprecated
    public String getFirstCourse() {
        if (this.record.length() == 0) {
            return null;
        }
        this.start = 0;
        return this.getNextCourse();
    }

    @Deprecated
    public String getNextCourse() {
        String next = null;
        if (this.start < this.record.length()) {
            next = this.record.substring(this.start, this.start + 4);
            this.start += 5;
        }
        return next;
    }

    public String getCourseGrade(String course) {
        int pos = this.record.indexOf(course);
        String grade = null;
        if (pos != -1) {
            grade = this.record.substring(pos + 4, pos + 5);
        }
        return grade;
    }

    public boolean setCourseGrade(String course, String grade) {
        grade = grade.toUpperCase();
        boolean ok = course.length() == 4;
        ok = ok && grade.length() == 1;
        ok = ok && GRADES.indexOf(grade) != -1;
        boolean bl = ok = ok && this.isDigit(course);
        if (ok) {
            int old = this.record.indexOf(course);
            this.record = old != -1 ? String.valueOf(this.record.substring(0, old + 4)) + grade + this.record.substring(old + 5) : String.valueOf(this.record) + course + grade;
        }
        return ok;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            Student otherS = (Student)other;
            result = this.getID().equals(otherS.getID());
        }
        return result;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public double getGpa() {
        double gpa = 0.0;
        int count = 0;
        int pos = 4;
        while (pos <= this.record.length()) {
            gpa -= (double)this.record.substring(pos, pos + 1).compareTo("F");
            ++count;
            pos += 5;
        }
        return gpa / (double)count;
    }

    public String toString() {
        return "CSE student: " + this.name;
    }

    private boolean isDigit(String s) {
        int i = 0;
        while (i < s.length()) {
            if (DIGITS.indexOf(s.substring(i, i + 1)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Student getRandom() {
        return Student.getRandom(false);
    }

    public static Student getRandom(boolean same) {
        if (same && lastST != null) {
            return lastST;
        }
        String id = "3";
        int i = 1;
        while (i < 9) {
            id = String.valueOf(id) + DIGITS.charAt(rng.nextInt(10));
            ++i;
        }
        String name = "";
        int i2 = 0;
        while (i2 < 4) {
            name = String.valueOf(name) + (char)(65 + rng.nextInt(26));
            ++i2;
        }
        int studentClass = rng.nextInt(5);
        lastST = studentClass < 2 ? new Student(id, name) : (studentClass == 2 ? new CEstudent(name) : (studentClass == 3 ? new SEstudent(name) : new ITstudent(name)));
        int courseCount = 1 + rng.nextInt(25);
        int i3 = 0;
        while (i3 < courseCount) {
            String course = "" + DIGITS.charAt(1 + rng.nextInt(4));
            int j = 0;
            while (j < 3) {
                course = String.valueOf(course) + DIGITS.charAt(rng.nextInt(10));
                ++j;
            }
            String grade = "" + GRADES.charAt(rng.nextInt(6));
            lastST.setCourseGrade(course, grade);
            ++i3;
        }
        return lastST;
    }

    public static void setSeed(long seed) {
        rng.setSeed(seed);
    }
}

