/*
 * Decompiled with CFR 0.152.
 */
package type.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import type.lang.IO;

public class PrintStream2
extends PrintStream {
    private boolean separator;
    private int width;
    private int decimals;

    public PrintStream2(File file) throws FileNotFoundException {
        super(new FileOutputStream(file));
    }

    public PrintStream2(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super((OutputStream)new FileOutputStream(file), false, csn);
    }

    public PrintStream2(OutputStream out) {
        super(out);
    }

    public PrintStream2(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public PrintStream2(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        super(out, autoFlush, encoding);
    }

    public PrintStream2(String fileName) throws FileNotFoundException {
        super(new FileOutputStream(fileName));
    }

    public PrintStream2(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super((OutputStream)new FileOutputStream(fileName), false, csn);
    }

    public PrintStream printf(String format, int value) {
        super.print(this.format(format, value));
        return this;
    }

    public PrintStream printf(String format, double value) {
        super.print(this.format(format, value));
        return this;
    }

    private String format(String format, int value) {
        this.convertMe(format);
        String result = this.separator ? new DecimalFormat("#,###").format(value) : "" + value;
        return this.size(result);
    }

    private String format(String format, double value) {
        this.convertMe(format);
        if (this.decimals == -1) {
            this.decimals = 6;
        }
        boolean fractional = value - Math.rint(value) != 0.0;
        BigDecimal bd = new BigDecimal(value);
        BigDecimal nu = bd.setScale(this.decimals, 4);
        value = nu.doubleValue();
        String pattern = this.decimals == 0 ? ".#" : "." + IO.repeat(this.decimals, '0');
        pattern = this.separator ? "#,##0" + pattern : "0" + pattern;
        String result = new DecimalFormat(pattern).format(value);
        if (fractional && this.decimals == 0) {
            result = String.valueOf(result) + ".";
        }
        return this.size(result);
    }

    private void convertMe(String format) {
        String result = "";
        if (format.length() == 0) {
            throw new RuntimeException("Zero-length Format!");
        }
        if (format.charAt(0) != '%') {
            throw new RuntimeException("% prefix missing!");
        }
        if ((format = format.substring(1)).charAt(0) == ',') {
            format = format.substring(1);
            result = ",";
        } else if (format.charAt(0) == '0') {
            format = format.substring(1);
            result = "Z";
        }
        int last = format.length();
        if ("df".indexOf(format.charAt(last - 1)) == -1) {
            throw new RuntimeException("Invalid conversion!");
        }
        result = String.valueOf(result) + format.substring(0, last - 1);
        this.extractAttributes(result);
    }

    private void extractAttributes(String fd) {
        this.separator = false;
        this.width = -1;
        this.decimals = -1;
        int n = fd.indexOf(44, 0);
        if (n > -1) {
            this.separator = true;
            fd = String.valueOf(fd.substring(0, n)) + fd.substring(n + 1);
        }
        if ((n = fd.indexOf(46, 0)) > -1) {
            this.decimals = Integer.parseInt(fd.substring(n + 1));
            fd = fd.substring(0, n);
        }
        if (fd.length() > 0) {
            this.width = Integer.parseInt(fd);
        }
    }

    private String size(String s) {
        int n = this.width - s.length();
        return String.valueOf(IO.repeat(n, ' ')) + s;
    }
}

