/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import type.ec.ProxyCL;
import type.ec.ProxyES;
import type.ec.ProxyIS;
import type.ec.ProxyOS;
import type.lang.IO;

public class ToolBox {
    private ToolBox() {
    }

    public static void crash(boolean condition, String msg) {
        if (condition) {
            throw new RuntimeException(msg);
        }
    }

    public static String repeat(int count, char c) {
        String s = "";
        int i = 1;
        while (i <= count) {
            s = String.valueOf(s) + c;
            ++i;
        }
        return s;
    }

    public static String launch(String app, String input) {
        Object[] allPara;
        if (app == null || app.length() == 0) {
            throw new RuntimeException("The app name is invalid!");
        }
        app = app.replace('\\', '/');
        int last = app.lastIndexOf("/");
        String path = IO.workingDir;
        if (last != -1) {
            path = app.substring(0, last);
        }
        app = app.substring(last + 1);
        String ret = null;
        Method m = null;
        try {
            ProxyCL cl = new ProxyCL(path);
            Class<?> c = cl.loadClass(app);
            Class[] types = new Class[1];
            String[] para = new String[]{};
            types[0] = para.getClass();
            m = c.getDeclaredMethod("main", types);
            allPara = new Object[]{para};
        }
        catch (Throwable th) {
            throw new RuntimeException("The app could not be launched!\n" + th, th);
        }
        ProxyOS pos = new ProxyOS();
        ProxyES pes = new ProxyES();
        ProxyIS pis = new ProxyIS(input);
        try {
            try {
                m.invoke(null, allPara);
                ret = pos.pop();
                if (!pis.empty()) {
                    throw new BufferOverflowException();
                }
            }
            catch (BufferOverflowException e) {
                throw new RuntimeException("The app consumed less input than you supplied!");
            }
            catch (Throwable th) {
                if (th.getCause() != null) {
                    th = th.getCause();
                }
                if (th instanceof BufferUnderflowException) {
                    throw new RuntimeException("The app demanded more input than you supplied!");
                }
                throw new RuntimeException("The app caused a runtime error!\n" + th, th);
            }
        }
        finally {
            pes.close();
            pos.close();
            pis.close();
        }
        return ret;
    }

    public static double mortgagePayment(double amount, double rate, int period) {
        ToolBox.crash(amount < 0.0, "Present value cannot be negative!");
        ToolBox.crash(rate <= 0.0, "Interest percent must be positive!");
        ToolBox.crash(rate >= 100.0, "Interest percent must be less than 100!");
        double numerator = (rate /= 1200.0) * amount;
        double denominator = Math.pow(1.0 + rate, period *= 12);
        denominator = 1.0 - 1.0 / denominator;
        return numerator / denominator;
    }

    public static double getBMI(double weight, String height) {
        double KILO_PER_POUND = 0.45359237;
        double INCH_PER_FOOT = 12.0;
        double M_PER_INCH = 0.0254;
        try {
            int inches;
            int feet;
            int quote = height.indexOf("'");
            if (quote != -1) {
                feet = Integer.parseInt(height.substring(0, quote));
                inches = Integer.parseInt(height.substring(quote + 1));
            } else {
                feet = Integer.parseInt(height);
                inches = 0;
            }
            double bmi = weight * 0.45359237 / Math.pow(((double)feet * 12.0 + (double)inches) * 0.0254, 2.0);
            ToolBox.crash(weight <= 0.0, "");
            ToolBox.crash(feet <= 0, "");
            ToolBox.crash(inches < 0 || inches >= 12, "");
            return bmi;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid parameters!");
        }
    }

    public static double factorial(int n) {
        ToolBox.crash(n < 0, "The parameter cannot be negative!");
        double result = 1.0;
        int i = 1;
        while (i <= n) {
            result *= (double)i;
            ++i;
        }
        return result;
    }
}

