/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import type.lang.IO;
import type.lib.CreditCard;
import type.lib.ToolBox;

public class RewardCard
extends CreditCard {
    public static final double DEFAULT_LIMIT = 5000.0;
    public static final int REWARD_RATE = 20;
    private int points = 0;
    private static final long serialVersionUID = 1L;

    public RewardCard(int no, String aName, double aLimit) {
        super(no, aName, aLimit);
        IO.format("RewardCard", "1hamzeh0");
    }

    public RewardCard(int no, String aName) {
        this(no, aName, 5000.0);
    }

    public int getPointBalance() {
        return this.points;
    }

    @Override
    public boolean charge(double amount) {
        if (super.charge(amount)) {
            this.points = (int)((double)this.points + Math.floor(amount / 20.0));
            return true;
        }
        return false;
    }

    @Override
    public void credit(double amount) {
        super.credit(amount);
        this.points = (int)((double)this.points - Math.floor(amount / 20.0));
    }

    public void redeem(int point) {
        ToolBox.crash(point < 0, "Negative number of points!");
        ToolBox.crash(point > this.points, "Number of points exceed point balance!");
        this.points -= point;
    }

    @Override
    public String toString() {
        String tmp = super.toString();
        return "RWRD" + tmp.substring(4, tmp.length() - 1) + ", POINTS=" + this.points + "]";
    }

    public boolean isSimilar(RewardCard other) {
        if (other == null) {
            return false;
        }
        return super.isSimilar(other) && this.points == other.points;
    }
}

