/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;
import type.lib.Stock;

public class Investment
implements Serializable {
    private Stock stock;
    private int qty;
    private double bookValue;
    private static Random rng = new Random();
    private static final long serialVersionUID = 1L;

    public Investment(Stock stock, int quantity, double bookValue) {
        this.stock = stock;
        this.setQty(quantity);
        this.setBookValue(bookValue);
        IO.format("Investment", "1hamzeh0");
    }

    public Investment(Investment investment) {
        this(investment.getStock(), investment.getQty(), investment.getBookValue());
    }

    public Stock getStock() {
        return this.stock;
    }

    public int getQty() {
        return this.qty;
    }

    public void setQty(int quantity) {
        this.qty = quantity;
    }

    public double getBookValue() {
        return this.bookValue;
    }

    public void setBookValue(double bookValue) {
        this.bookValue = bookValue;
    }

    public String toString() {
        String tmp = "null";
        if (this.stock != null) {
            tmp = this.stock.toString();
        }
        return String.valueOf(tmp) + " QTY=" + this.qty + " BV=" + this.bookValue;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            Investment otherI = (Investment)other;
            result = otherI.stock == this.stock || otherI.stock != null && otherI.getStock().equals(this.stock);
            result = result && Math.abs(otherI.getBookValue() - this.bookValue) < 0.01;
        }
        return result;
    }

    public int hashCode() {
        int PRIME = 23;
        return this.getStock().hashCode() + 23 * new Integer(this.getQty()).hashCode() + 529 * new Double(this.getBookValue()).hashCode();
    }

    public Investment cloneMe() {
        if (this.stock == null) {
            return new Investment(null, this.qty, this.bookValue);
        }
        return new Investment(this.stock.cloneMe(), this.qty, this.bookValue);
    }

    public static Investment getRandom() {
        char l1 = (char)(65 + rng.nextInt(26));
        char l2 = (char)(65 + rng.nextInt(26));
        Stock s = new Stock("." + l1 + l2);
        return new Investment(s, 1 + rng.nextInt(5000), (rng.nextGaussian() / 50.0 + 1.0) * s.getPrice());
    }
}

