/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lang.IO;
import type.lib.ToolBox;

public class Equation
implements Serializable {
    private double coef2;
    private double coef1;
    private double coef0;
    private double root1;
    private double root2;
    private int rootCount;
    public static final double EPSILON = 1.0E-6;
    private static final long serialVersionUID = 1L;

    public Equation() {
        this(0.0, 0.0, 0.0);
    }

    public Equation(Equation equation) {
        this(equation.getCoefficient(2), equation.getCoefficient(1), equation.getCoefficient(0));
    }

    public Equation(double a, double b, double c) {
        IO.format("Equation", "1hamzeh0");
        this.setCoefficient(a, b, c);
    }

    public void setCoefficient(double a, double b, double c) {
        this.coef0 = c;
        this.coef1 = b;
        this.coef2 = a;
        this.findRoot();
    }

    public double getCoefficient(int coefNum) {
        ToolBox.crash(coefNum < 0 || coefNum > 2, "Invalid Coefficient Number!");
        if (coefNum == 0) {
            return this.coef0;
        }
        if (coefNum == 1) {
            return this.coef1;
        }
        return this.coef2;
    }

    public double getRoot(int rootNum) {
        ToolBox.crash(rootNum <= 0 || rootNum > this.rootCount, "Invalid Root Number!");
        if (rootNum == 1) {
            return this.root1;
        }
        return this.root2;
    }

    public int getRootCount() {
        return this.rootCount;
    }

    private void findRoot() {
        if (this.coef2 == 0.0) {
            if (this.coef1 == 0.0) {
                this.rootCount = this.coef0 == 0.0 ? -1 : 0;
            } else {
                this.rootCount = 1;
                this.root1 = -this.coef0 / this.coef1;
            }
        } else {
            double delta = this.coef1 * this.coef1 - 4.0 * this.coef2 * this.coef0;
            if (delta < 0.0) {
                this.rootCount = 0;
            } else if (delta == 0.0) {
                this.rootCount = 1;
                this.root1 = -this.coef1 / (2.0 * this.coef2);
            } else {
                this.rootCount = 2;
                this.root1 = (-this.coef1 - Math.sqrt(delta)) / (2.0 * this.coef2);
                this.root2 = (-this.coef1 + Math.sqrt(delta)) / (2.0 * this.coef2);
                if (this.root2 < this.root1) {
                    double tmp = this.root1;
                    this.root1 = this.root2;
                    this.root2 = tmp;
                }
            }
        }
    }

    public String toString() {
        String s = String.valueOf(this.coef2) + "x^2 ";
        s = this.coef1 >= 0.0 ? String.valueOf(s) + "+ " : String.valueOf(s) + "- ";
        s = String.valueOf(s) + Math.abs(this.coef1) + "x ";
        s = this.coef0 >= 0.0 ? String.valueOf(s) + "+ " : String.valueOf(s) + "- ";
        s = String.valueOf(s) + Math.abs(this.coef0) + "  =  0";
        return s;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            Equation eqnOther = (Equation)other;
            result = this.rootCount != eqnOther.getRootCount() ? false : (this.rootCount == 1 ? Math.abs(this.root1 - eqnOther.getRoot(1)) < 1.0E-6 : (this.rootCount == 2 ? Math.abs(this.root1 - eqnOther.getRoot(1)) < 1.0E-6 && Math.abs(this.root2 - eqnOther.getRoot(2)) < 1.0E-6 : true));
        }
        return result;
    }

    public int hashCode() {
        int PRIME = 23;
        double hash = 529.0 * this.coef2 + 23.0 * this.coef1 + this.coef0;
        return (int)hash;
    }
}

