/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import type.lang.IO;
import type.lib.Client;
import type.lib.Contact;
import type.lib.Fresh;
import type.lib.Item;
import type.lib.Supplier;
import type.lib.Trx;

public class AbstractFoods
implements Serializable {
    private List<Trx> journal;
    private Map<String, Item> inventory;
    private Map<String, Contact> contacts;
    private static final long serialVersionUID = 1L;

    public AbstractFoods() {
        this.inventory = new TreeMap<String, Item>();
        this.contacts = new TreeMap<String, Contact>();
        this.journal = new ArrayList<Trx>();
    }

    public AbstractFoods(Map<String, Item> inventory, Map<String, Contact> contacts, List<Trx> journal) {
        this.inventory = inventory;
        this.contacts = contacts;
        this.journal = journal;
    }

    public Map<String, Item> getInventory() {
        return this.inventory;
    }

    public Map<String, Contact> getContacts() {
        return this.contacts;
    }

    public List<Trx> getJournal() {
        return this.journal;
    }

    public String toString() {
        return "Abstract Foods Company";
    }

    public static AbstractFoods getRandom() {
        Item it;
        double price;
        String number;
        String name;
        Random rng = new Random();
        String CAPS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String DIGI = "0123456789";
        int ITEM_COUNT = 25;
        int CONTACT_COUNT = 100;
        int ONE_DAY = 86400000;
        int order = 0;
        int invoice = 0;
        Date date = new Date();
        ArrayList<Trx> journal = new ArrayList<Trx>();
        TreeMap<String, Item> inv = new TreeMap<String, Item>();
        String CEREAL = "Oat       Chocolate Honey     Wheat     MultigrainAlmond    Nuts      Fruits    Raisin    Maple     ";
        int i = 0;
        while (i < 25) {
            int p1 = 10 * rng.nextInt(10);
            int p2 = 10 * rng.nextInt(10);
            String word1 = "Oat       Chocolate Honey     Wheat     MultigrainAlmond    Nuts      Fruits    Raisin    Maple     ".substring(p1, p1 + 10).trim();
            String word2 = "Oat       Chocolate Honey     Wheat     MultigrainAlmond    Nuts      Fruits    Raisin    Maple     ".substring(p2, p2 + 10).trim();
            if (rng.nextInt(2) == 0) {
                name = String.valueOf(word1) + " " + word2 + " Cereal by ";
                name = String.valueOf(name) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26)) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26));
            } else {
                name = String.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26))) + "0123456789".charAt(rng.nextInt(10));
                name = String.valueOf(name) + " " + word1 + " Cereal";
            }
            number = i == 0 ? "2910h123" : "2910h" + IO.format(rng.nextInt(999), "3Z");
            price = 1.25 + (double)rng.nextInt(575) / 100.0;
            it = new Item(number, name, price);
            inv.put(number, it);
            ++i;
        }
        String ICE = "Vanilla   Chocolate Peanut    Raspberry Praline   Twirl     Fudge     Brownie   Nuts      Strawberry";
        int i2 = 0;
        while (i2 < 25) {
            String name2;
            int p1 = 10 * rng.nextInt(10);
            int p2 = 10 * rng.nextInt(10);
            String word1 = "Vanilla   Chocolate Peanut    Raspberry Praline   Twirl     Fudge     Brownie   Nuts      Strawberry".substring(p1, p1 + 10).trim();
            String word2 = "Vanilla   Chocolate Peanut    Raspberry Praline   Twirl     Fudge     Brownie   Nuts      Strawberry".substring(p2, p2 + 10).trim();
            if (rng.nextInt(2) == 0) {
                name2 = String.valueOf(word1) + " Ice Cream with " + word2 + " by ";
                name2 = String.valueOf(name2) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26)) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26));
            } else {
                name2 = String.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26))) + "0123456789".charAt(rng.nextInt(10));
                name2 = String.valueOf(name2) + " " + word1 + " Ice Cream";
            }
            String number2 = i2 == 0 ? "1409S123" : "1409S" + IO.format(rng.nextInt(999), "3Z");
            double price2 = 2.75 + (double)rng.nextInt(500) / 100.0;
            Item it2 = new Item(number2, name2, price2);
            inv.put(number2, it2);
            ++i2;
        }
        String CHEESE = "Cheddar   Swiss     Cream     Fruilano  Edam      Gouda     Monterey  Colby     Feta      Provolone ";
        int i3 = 0;
        while (i3 < 25) {
            int p = 10 * rng.nextInt(10);
            String word = "Cheddar   Swiss     Cream     Fruilano  Edam      Gouda     Monterey  Colby     Feta      Provolone ".substring(p, p + 10).trim();
            name = "";
            if (rng.nextInt(2) == 0) {
                name = String.valueOf(name) + "Semi-";
            }
            if (rng.nextInt(5) == 0) {
                name = String.valueOf(name) + "Hard ";
            } else if (rng.nextInt(4) == 0) {
                name = String.valueOf(name) + "Soft ";
            }
            name = String.valueOf(name) + word + " Cheese by ";
            name = String.valueOf(name) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26)) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26));
            number = i3 == 0 ? "2002H123" : "2002H" + IO.format(rng.nextInt(999), "3Z");
            price = 3.75 + (double)rng.nextInt(300) / 100.0;
            it = new Item(number, name, price);
            inv.put(number, it);
            ++i3;
        }
        String MEAT = "Lamb      Stew      Veal      Beef      Loin      Rib       Fillet    Sirloin   Breast    Chicken   ";
        String ALSO = "Ground    Minced    Fine      Fine Cut  Thick Cut Top Cut   Crown     Side      Chop      Roast     ";
        int i4 = 0;
        while (i4 < 25) {
            String number3;
            String name3;
            int p1 = 10 * rng.nextInt(10);
            int p2 = 10 * rng.nextInt(10);
            String word1 = "Lamb      Stew      Veal      Beef      Loin      Rib       Fillet    Sirloin   Breast    Chicken   ".substring(p1, p1 + 10).trim();
            String word2 = "Ground    Minced    Fine      Fine Cut  Thick Cut Top Cut   Crown     Side      Chop      Roast     ".substring(p2, p2 + 10).trim();
            if (rng.nextInt(2) == 0) {
                name3 = String.valueOf(word2) + " " + word1 + " Meat by ";
                name3 = String.valueOf(name3) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26)) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26));
            } else {
                name3 = String.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26))) + "0123456789".charAt(rng.nextInt(10));
                name3 = String.valueOf(name3) + " " + word1 + " Meat";
            }
            if (i4 == 0) {
                number3 = "0905A123";
            } else {
                String tmp = IO.format(rng.nextInt(999), "3Z");
                if (i4 == 1) {
                    tmp = "112";
                }
                number3 = "0905A" + tmp;
            }
            double price3 = 3.75 + (double)rng.nextInt(300) / 100.0;
            Calendar cal = Calendar.getInstance();
            cal.add(10, rng.nextInt(50000));
            Fresh it3 = new Fresh(number3, name3, price3, cal.getTime());
            inv.put(number3, it3);
            ++i4;
        }
        TreeMap<String, Contact> con = new TreeMap<String, Contact>();
        String COMP = "Corp.     Inc.      LTD       Mart      Incorp.   EnterpriseCompany   INC       Ltd.      Limited   ";
        int i5 = 0;
        while (i5 < 100) {
            Iterator tor;
            String contactNo;
            Contact contact;
            String name4;
            int p = 10 * rng.nextInt(10);
            String word = "Corp.     Inc.      LTD       Mart      Incorp.   EnterpriseCompany   INC       Ltd.      Limited   ".substring(p, p + 10).trim();
            if (rng.nextInt(2) == 0) {
                name4 = String.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26))) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26));
                name4 = String.valueOf(name4) + " " + word;
            } else {
                name4 = "The " + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rng.nextInt(26)) + "0123456789".charAt(rng.nextInt(10));
                name4 = String.valueOf(name4) + " " + word + " Group";
            }
            if (rng.nextInt(2) == 0) {
                String rating = "" + "ABC".charAt(rng.nextInt(3));
                if (rng.nextInt(2) == 0) {
                    rating = String.valueOf(rating) + "+";
                }
                if (rng.nextInt(2) == 0) {
                    rating = String.valueOf(rating) + "+";
                }
                contact = new Client(name4, "", rating);
                contactNo = IO.format(contact.getNumber(), "5Z");
                tor = inv.keySet().iterator();
                ++invoice;
                if (rng.nextInt(2) == 0) {
                    date.setTime(date.getTime() - (long)(86400000 * (1 + rng.nextInt(2))));
                }
                while (tor.hasNext()) {
                    double pp;
                    int qq;
                    String num = (String)tor.next();
                    Item item = (Item)inv.get(num);
                    if (rng.nextInt(15) != 0 || !item.sell(qq = rng.nextInt(50) + 1, pp = (double)qq * item.getUnitPrice())) continue;
                    Trx trx = new Trx(date, "S", "" + invoice, contact, item, qq, pp);
                    journal.add(trx);
                }
            } else {
                TreeMap<Item, Double> catalog = new TreeMap<Item, Double>();
                int supplyCount = 1 + rng.nextInt(10);
                int count = 0;
                contact = new Supplier(name4, "");
                contactNo = IO.format(contact.getNumber(), "5Z");
                while (count < supplyCount) {
                    tor = inv.keySet().iterator();
                    ++order;
                    if (rng.nextInt(2) == 0) {
                        date.setTime(date.getTime() - (long)(86400000 * (1 + rng.nextInt(2))));
                    }
                    while (tor.hasNext()) {
                        String num = (String)tor.next();
                        Item item = (Item)inv.get(num);
                        if (rng.nextInt(20) != 0 || count >= supplyCount) continue;
                        double pp = item.getUnitPrice() * (0.6 + rng.nextDouble() / 3.0);
                        catalog.put(item, new Double(pp));
                        ++count;
                        int qq = rng.nextInt(2000) + 1;
                        pp = (double)qq * pp;
                        item.purchase(qq, pp);
                        Trx trx = new Trx(date, "P", "" + order, contact, item, qq, pp);
                        journal.add(trx);
                    }
                }
                ((Supplier)contact).setCatalog(catalog);
            }
            con.put(contactNo, contact);
            ++i5;
        }
        for (String contactNum : con.keySet()) {
            Contact contact = (Contact)con.get(contactNum);
            if (!(contact instanceof Client)) continue;
            ++invoice;
            if (rng.nextInt(2) == 0) {
                date.setTime(date.getTime() - (long)(86400000 * (1 + rng.nextInt(2))));
            }
            for (String num : inv.keySet()) {
                double pp;
                int qq;
                Item item = (Item)inv.get(num);
                if (rng.nextInt(15) != 0 || !item.sell(qq = rng.nextInt(50) + 1, pp = (double)qq * item.getUnitPrice())) continue;
                Trx trx = new Trx(date, "S", "" + invoice, contact, item, qq, pp);
                journal.add(trx);
            }
        }
        AbstractFoods af = new AbstractFoods(inv, con, journal);
        IO.printObject(af, "data.af");
        return af;
    }
}

