/*
 * Decompiled with CFR 0.152.
 */
package type.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import type.ec.ProxyCL;
import type.ec.ProxyES;
import type.ec.ProxyIS;
import type.ec.ProxyOS;
import type.lang.Crypter;
import type.lang.UniPanel;
import type.lang.UniReader;
import type.lang.UniWriter;

public class IO {
    public static UniReader in = new UniReader();
    public static UniWriter out = new UniWriter();
    public static char fillChar = (char)32;
    public static String workingDir = System.getProperty("user.dir");
    private static char alignment;
    private static boolean separator;
    private static char base;
    private static boolean scientific;
    private static boolean zeroFill;
    private static int width;
    private static int decimals;
    private static String pattern;
    private static UniPanel uniPnl;
    private static String pdr;
    private static Crypter cypher;

    static {
        uniPnl = null;
        pdr = "";
        cypher = new Crypter();
    }

    private IO() {
    }

    public static UniPanel getUniPanel() {
        if (uniPnl == null) {
            return null;
        }
        uniPnl.clear();
        return uniPnl;
    }

    public static UniPanel getNewUniPanel(String title) {
        JFrame frame = new JFrame(title);
        frame.setSize(1000, 600);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        UniPanel up = new UniPanel();
        frame.getContentPane().add(up);
        up.clear();
        frame.setVisible(true);
        return up;
    }

    public static String launch(String app, String input) {
        Object[] allPara;
        if (app == null || app.length() == 0) {
            throw new RuntimeException("The app name is invalid!");
        }
        app = app.replace('\\', '/');
        int last = app.lastIndexOf("/");
        String path = workingDir;
        if (last != -1) {
            path = app.substring(0, last);
        }
        app = app.substring(last + 1);
        String ret = null;
        Method m = null;
        try {
            ProxyCL cl = new ProxyCL(path);
            Class<?> c = cl.loadClass(app);
            Class[] types = new Class[1];
            String[] para = new String[]{};
            types[0] = para.getClass();
            m = c.getDeclaredMethod("main", types);
            allPara = new Object[]{para};
        }
        catch (Throwable th) {
            throw new RuntimeException("The app could not be launched!\n" + th, th);
        }
        ProxyOS pos = new ProxyOS();
        ProxyES pes = new ProxyES();
        ProxyIS pis = new ProxyIS(input);
        try {
            try {
                m.invoke(null, allPara);
                ret = pos.pop();
                if (!pis.empty()) {
                    throw new BufferOverflowException();
                }
            }
            catch (BufferOverflowException e) {
                throw new RuntimeException("The app consumed less input than you supplied!");
            }
            catch (Throwable th) {
                if (th.getCause() != null) {
                    th = th.getCause();
                }
                if (th instanceof BufferUnderflowException) {
                    throw new RuntimeException("The app demanded more input than you supplied!");
                }
                throw new RuntimeException("The app caused a runtime error!\n" + th, th);
            }
        }
        finally {
            pes.close();
            pos.close();
            pis.close();
        }
        return ret;
    }

    private static void extractAttributes(String fd) {
        fd = fd.toUpperCase();
        alignment = (char)82;
        separator = false;
        base = (char)68;
        scientific = false;
        zeroFill = false;
        width = -1;
        decimals = -1;
        int n = fd.indexOf(76, 0);
        if (n > -1) {
            alignment = (char)76;
            fd = String.valueOf(fd.substring(0, n)) + fd.substring(n + 1);
        }
        if ((n = fd.indexOf(67, 0)) > -1) {
            alignment = (char)67;
            fd = String.valueOf(fd.substring(0, n)) + fd.substring(n + 1);
        }
        if ((n = fd.indexOf(44, 0)) > -1) {
            separator = true;
            pattern = String.valueOf(pattern) + ",###";
            fd = String.valueOf(fd.substring(0, n)) + fd.substring(n + 1);
        }
        if ((n = fd.indexOf(88, 0)) > -1) {
            base = (char)88;
            fd = String.valueOf(fd.substring(0, n)) + fd.substring(n + 1);
        } else {
            n = fd.indexOf(66, 0);
            if (n > -1) {
                base = (char)66;
                fd = String.valueOf(fd.substring(0, n)) + fd.substring(n + 1);
            }
        }
        n = fd.indexOf(83, 0);
        if (n > -1) {
            scientific = true;
            fd = String.valueOf(fd.substring(0, n)) + fd.substring(n + 1);
        }
        if ((n = fd.indexOf(90, 0)) > -1) {
            zeroFill = true;
            fd = String.valueOf(fd.substring(0, n)) + fd.substring(n + 1);
        }
        if ((n = fd.indexOf(46, 0)) > -1) {
            decimals = Integer.parseInt(fd.substring(n + 1));
            fd = fd.substring(0, n);
        }
        if (fd.length() > 0) {
            width = Integer.parseInt(fd);
        }
    }

    private static String size(String s) {
        int n = width - s.length();
        if (alignment == 'R') {
            return String.valueOf(IO.repeat(n, fillChar)) + s;
        }
        if (alignment == 'L') {
            return String.valueOf(s) + IO.repeat(n, fillChar);
        }
        return String.valueOf(IO.repeat(n / 2, fillChar)) + s + IO.repeat(n / 2 + n % 2, fillChar);
    }

    public static String repeat(int count, char c) {
        String s = "";
        int i = 1;
        while (i <= count) {
            s = String.valueOf(s) + c;
            ++i;
        }
        return s;
    }

    private static String formatInteger(long value, String fd, int len) {
        String s;
        int MAX_BITS = 64;
        IO.extractAttributes(fd);
        if (base == 'B') {
            s = Long.toBinaryString(value);
            s = String.valueOf(IO.repeat(64, '0')) + s;
            s = s.substring(s.length() - len);
        } else if (base == 'X') {
            s = Long.toHexString(value);
            s = String.valueOf(IO.repeat(16, '0')) + s;
            s = s.substring(s.length() - len / 4);
        } else if (separator) {
            s = new DecimalFormat("#,###").format(value);
        } else {
            s = "" + value;
            if (zeroFill) {
                s = String.valueOf(IO.repeat(width - s.length(), '0')) + s;
            }
        }
        return IO.size(s);
    }

    public static String format(byte value, String fd) {
        return IO.formatInteger(value, fd, 8);
    }

    public static String format(short value, String fd) {
        return IO.formatInteger(value, fd, 16);
    }

    public static String format(char value, String fd) {
        return IO.formatInteger(value, fd, 16);
    }

    public static String format(int value, String fd) {
        return IO.formatInteger(value, fd, 32);
    }

    public static String format(long value, String fd) {
        return IO.formatInteger(value, fd, 64);
    }

    public static String format(float value, String fd) {
        String s;
        IO.extractAttributes(fd);
        if (base == 'B') {
            s = Integer.toBinaryString(Float.floatToIntBits(value));
            s = String.valueOf(IO.repeat(32, '0')) + s;
            s = s.substring(s.length() - 32);
        } else if (base == 'X') {
            s = Integer.toHexString(Float.floatToIntBits(value));
            s = String.valueOf(IO.repeat(8, '0')) + s;
            s = s.substring(s.length() - 8);
        } else {
            String string = pattern = decimals == -1 ? ".#" : "." + IO.repeat(decimals, '0');
            pattern = scientific ? "0" + pattern + "E0" : (separator ? "#,##0" + pattern : "0" + pattern);
            s = new DecimalFormat(pattern).format(value);
        }
        return IO.size(s);
    }

    public static String format(double value, String fd) {
        String s;
        IO.extractAttributes(fd);
        if (base == 'B') {
            s = Long.toBinaryString(Double.doubleToLongBits(value));
            s = String.valueOf(IO.repeat(64, '0')) + s;
            s = s.substring(s.length() - 64);
        } else if (base == 'X') {
            s = Long.toHexString(Double.doubleToLongBits(value));
            s = String.valueOf(IO.repeat(16, '0')) + s;
            s = s.substring(s.length() - 16);
        } else {
            String string = pattern = decimals == -1 ? ".#" : "." + IO.repeat(decimals, '0');
            pattern = scientific ? "0" + pattern + "E0" : (separator ? "#,##0" + pattern : "0" + pattern);
            s = new DecimalFormat(pattern).format(value);
        }
        return IO.size(s);
    }

    public static String format(boolean value, String fd) {
        IO.extractAttributes(fd);
        if (value) {
            return IO.size("true");
        }
        return IO.size("false");
    }

    public static String format(Object value, String fd) {
        if (fd.indexOf("hamzeh") == 1 && fd.length() == 8) {
            if (fd.charAt(0) == '1' && fd.charAt(7) == '0') {
                pdr = String.valueOf(pdr) + "|" + value.toString();
                return null;
            }
            if (fd.charAt(0) == '1' && fd.charAt(7) == '1') {
                String tmp = pdr;
                pdr = "";
                return tmp;
            }
            if (fd.charAt(0) == '0' && fd.charAt(7) == '0') {
                cypher.crypt((byte[])value, true);
                return null;
            }
            if (fd.charAt(0) == '0' && fd.charAt(7) == '1') {
                cypher.crypt((byte[])value, false);
                return null;
            }
            if (fd.charAt(0) == '2' && fd.charAt(7) == '0') {
                return cypher.crypt(value.toString(), true, false);
            }
            if (fd.charAt(0) == '2' && fd.charAt(7) == '1') {
                return cypher.crypt(value.toString(), false, false);
            }
            if (fd.charAt(0) == '2' && fd.charAt(7) == '2') {
                return cypher.crypt(value.toString(), true, true);
            }
            if (fd.charAt(0) == '2' && fd.charAt(7) == '3') {
                return cypher.crypt(value.toString(), false, true);
            }
            if (fd.charAt(0) == '3' && fd.charAt(7) == '0') {
                uniPnl = (UniPanel)value;
                return null;
            }
            if (fd.charAt(0) == '3' && fd.charAt(7) == '1') {
                uniPnl = null;
                return null;
            }
        }
        if (value == null) {
            return null;
        }
        IO.extractAttributes(fd);
        return IO.size(value.toString());
    }

    public static char readChar() {
        char c = '\u0000';
        String s = in.readLine();
        if (s.length() != 1) {
            throw new RuntimeException("Type Mismatch!");
        }
        c = s.charAt(0);
        return c;
    }

    public static byte readByte() {
        return Byte.valueOf(in.readLine().trim());
    }

    public static short readShort() {
        return Short.valueOf(in.readLine().trim());
    }

    public static int readInt() {
        return Integer.valueOf(in.readLine().trim());
    }

    public static long readLong() {
        return Long.valueOf(in.readLine().trim());
    }

    public static float readFloat() {
        return Float.valueOf(in.readLine().trim()).floatValue();
    }

    public static double readDouble() {
        return Double.valueOf(in.readLine().trim());
    }

    public static boolean readBoolean() {
        return Boolean.valueOf(in.readLine());
    }

    public static String readLine() {
        return in.readLine();
    }

    public static void println() {
        out.println();
    }

    public static void print(char value) {
        out.print(value);
    }

    public static void println(char value) {
        out.println(value);
    }

    public static void print(long value) {
        out.print(value);
    }

    public static void println(long value) {
        out.println(value);
    }

    public static void print(double value) {
        out.print(value);
    }

    public static void println(double value) {
        out.println(value);
    }

    public static void print(boolean value) {
        out.print(value);
    }

    public static void println(boolean value) {
        out.println(value);
    }

    public static void print(Object value) {
        out.print(value);
    }

    public static void println(Object value) {
        out.println(value);
    }

    public static void print(byte value, String fd) {
        out.print(value, fd);
    }

    public static void println(byte value, String fd) {
        out.println(value, fd);
    }

    public static void print(short value, String fd) {
        out.print(value, fd);
    }

    public static void println(short value, String fd) {
        out.println(value, fd);
    }

    public static void print(char value, String fd) {
        out.print(value, fd);
    }

    public static void println(char value, String fd) {
        out.println(value, fd);
    }

    public static void print(int value, String fd) {
        out.print(value, fd);
    }

    public static void println(int value, String fd) {
        out.println(value, fd);
    }

    public static void print(long value, String fd) {
        out.print(value, fd);
    }

    public static void println(long value, String fd) {
        out.println(value, fd);
    }

    public static void print(float value, String fd) {
        out.print(value, fd);
    }

    public static void println(float value, String fd) {
        out.println(value, fd);
    }

    public static void print(double value, String fd) {
        out.print(value, fd);
    }

    public static void println(double value, String fd) {
        out.println(value, fd);
    }

    public static void print(boolean value, String fd) {
        out.print(value, fd);
    }

    public static void println(boolean value, String fd) {
        out.println(value, fd);
    }

    public static void print(Object value, String fd) {
        out.print(value, fd);
    }

    public static void println(Object value, String fd) {
        out.println(value, fd);
    }

    public static Object readObject(String fileName) {
        try {
            if (!new File(fileName).isAbsolute()) {
                fileName = String.valueOf(workingDir) + File.separator + fileName;
            }
            FileInputStream is = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(is);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void printObject(Object value, String fileName) {
        try {
            if (!new File(fileName).isAbsolute()) {
                fileName = String.valueOf(workingDir) + File.separator + fileName;
            }
            FileOutputStream os = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(value);
            oos.flush();
            os.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

