#define _POSIX_SOURCE 1
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <errno.h>

/*
   You might have to edit the includes: instead of ../include
   use /cs/fac/src/MediaMath/include and instead of ../ImageBasics
   use /cs/fac/src/MediaMath/ImageBasics
*/

#include <media_all.h>
#include <one-and-two-D.h>

#include "declarations.h"
#include "proc.h"

char *SerialPortName;
int SetTermFlag;

/*
   If you want to use functions from other modules then you include
   them in the import header
*/

/*awkimportstart***********************************************************
Module: imagemath.so
Symbol: fimgTypenum
Symbol: fmatTypenum
Symbol: fsclnTypenum
Symbol: NonPosSize
Function: mksimple_ftmpl
Function: mksimple_ucscln
***********************************************************awkimportstop*/

/*awkvarstart**************************************************************
Name: RobotError
Doc: Error message. An error condition from the port connected to the robot.
Doc: Usualy comes from communication error.
Value: 
**************************************************************awkvarstop*/
/*awkvarstart**************************************************************
Name: RobIsOn
Doc: Global variable. It is t when the link to the robot is on.
Value: 
**************************************************************awkvarstop*/


/*awkstart**************************************************************
Name: rob_init_lisp
MinArgs: 0
MaxArgs: 0
Type: function
Synopsis: rob_init()
Doc: Opens communications with the CRS arm. Sets some usefull defaults
SEE: rob_quit
Example: rob_init();
**************************************************************awkstop*/

L_Ptr rob_init_lisp()
{
  if (!NULLP(boundp(SRobIsOn)))
    error_signal(Srob_init_lisp,SRobotError,SRobIsOn,NIL);
  SerialPortName = "/dev/ttyS0";
  SetTermFlag = 1;
  if (rob_init())
    error_signal(Srob_init_lisp,SRobotError,NIL,NIL);
  speed(30);
  set(SRobIsOn, St);
  return NIL;
}

/*awkstart**************************************************************
Name: rob_quit_lisp
MinArgs: 0
MaxArgs: 0
Type: function
Synopsis: rob_quit()
Doc: Close the connection to the robot
SEE: rob_init
Example: rob_quit()
**************************************************************awkstop*/

L_Ptr rob_quit_lisp()
{
  if (NULLP(boundp(SRobIsOn)))
    error_signal(Srob_quit_lisp,SRobotError,SRobIsOn,NIL);
  rob_quit();
  makunbound(SRobIsOn);
  return NIL;
}

/*awkstart**************************************************************
Name: write_cmnd_lisp
MinArgs: 1
MaxArgs: 1
Type: function
Synopsis: write_cmnd(<str>)
Doc: Write a command <str> to the output port. <str> is a string.
Doc: It then checks for reply. It returns t on success.
SEE: rob_init
Example: write_cmnd("READY");
**************************************************************awkstop*/

L_Ptr write_cmnd_lisp(str)
     L_Ptr str;
{
  char *s;
  if (NULLP(boundp(SRobIsOn)))
    error_signal(Swrite_cmnd_lisp,SRobotError,SRobIsOn,NIL);

  if (!STRNGP(str))
    error_signal(Swrite_cmnd_lisp,SWrongTypeArg,Sstringp,NIL);
  
  s = XSTRNG(str);
  write_cmnd(s);
  return NIL;
}

/*awkstart**************************************************************
Name: jog_lisp
MinArgs: 3
MaxArgs: 3
Type: function
Synopsis: jog(<float1>,<float2>,<float3>)
Doc: Performs a cartesian movement on the arm, by interpolating the
Doc: motions between several joints. <float1>,<float2>,<float3> represent
Doc: relative displacements for axes X, Y, Z. The interpolation is done
Doc: in the CRS controller.
SEE: joint
Example: jog(10.0,10.0,0.0);
**************************************************************awkstop*/

L_Ptr jog_lisp(Dx,Dy,Dz)
     L_Ptr Dx, Dy, Dz;
{
  float x, y, z;

  if (NULLP(boundp(SRobIsOn)))
    error_signal(Sjog_lisp ,SRobotError, SRobIsOn, NIL);

  Dx = to_float(Dx);
  x = XFLOAT(Dx);
  Dy = to_float(Dy);
  y = XFLOAT(Dy);
  Dz = to_float(Dz);
  z = XFLOAT(Dz);

  if (!jog(x,y,z))
    error_signal(Sjog_lisp,SRobotError,NIL,LIST3(Dx,Dy,Dz));
  return NIL;
}

/*awkstart**************************************************************
Name: joint_lisp
MinArgs: 2
MaxArgs: 2
Type: function
Synopsis: joint(<int1>,<float>)
Doc: Move joint # <int1> to <float> degrees (absolute).
SEE: jog
Example: joint(1,0);joint(2,0);joint(3,0);joint(4,0);joint(5,0);
**************************************************************awkstop*/

L_Ptr joint_lisp(jnt,angle)
     L_Ptr jnt,angle;
{
  int j, a;

  if (NULLP(boundp(SRobIsOn)))
    error_signal(Sjoint_lisp ,SRobotError, SRobIsOn, NIL);

  jnt = to_integer(jnt);
  j = XINT(jnt);
  angle = to_integer(angle);
  a = XINT(angle);

  if (!joint(j,a))
    error_signal(Sjoint_lisp,SRobotError,NIL,LIST2(jnt,angle));
  return NIL;
}

/*awkstart**************************************************************
Name: servo_open_lisp
MinArgs: 1
MaxArgs: 1
Type: function
Synopsis: servo_open(<float>)
Doc: Opens the servo ogripper with a given force <float>. Servo gripper's
Doc: shouldn't be used at more than 75% torque.
SEE: servo_close
Example: servo_open(10);
**************************************************************awkstop*/

L_Ptr servo_open_lisp(force)
     L_Ptr force;
{
  int f;

  if (NULLP(boundp(SRobIsOn)))
    error_signal(Sservo_open_lisp ,SRobotError, SRobIsOn, NIL);

  force = to_integer(force);
  f = XINT(force);

  if (!servo_open(f))
    error_signal(Sservo_open_lisp,SRobotError,NIL,force);
  return NIL;
}


/*awkstart**************************************************************
Name: servo_close_lisp
MinArgs: 1
MaxArgs: 1
Type: function
Synopsis: servo_close(<float>)
Doc: Closes the servo ogripper with a given force <float>. Servo gripper's
Doc: shouldn't be used at more than 75% torque.
SEE: servo_open
Example: servo_close(10);
**************************************************************awkstop*/

L_Ptr servo_close_lisp(force)
     L_Ptr force;
{
  int f;

  if (NULLP(boundp(SRobIsOn)))
    error_signal(Sservo_close_lisp ,SRobotError, SRobIsOn, NIL);

  force = to_integer(force);
  f = XINT(force);

  if (!servo_close(f))
    error_signal(Sservo_close_lisp,SRobotError,NIL,force);
  return NIL;
}

/*awkstart**************************************************************
Name: speed_lisp
MinArgs: 1
MaxArgs: 1
Type: function
Synopsis: speed(<float>)
Doc: Sets the speed to <float>. Maximum speed is 100.
SEE: jog, joint
Example: speed(10);
**************************************************************awkstop*/

L_Ptr speed_lisp(spd)
     L_Ptr spd;
{
  int s;

  if (NULLP(boundp(SRobIsOn)))
    error_signal(Sspeed_lisp ,SRobotError, SRobIsOn, NIL);

  spd = to_integer(spd);
  s = XINT(spd);

  if (!speed(s))
    error_signal(Sspeed_lisp,SRobotError,NIL,spd);
  return NIL;
}

/*awkstart**************************************************************
Name: home_lisp
MinArgs: 0
MaxArgs: 0
Type: function
Synopsis: home()
Doc: Assuming that all the joints are within the corect range
Doc: move to the home position
SEE: ready, jog, manual
Example: manual_joint(); home();
**************************************************************awkstop*/

L_Ptr home_lisp()
{
  if (NULLP(boundp(SRobIsOn)))
    error_signal(Shome_lisp ,SRobotError, SRobIsOn, NIL);

  if (!home())
    error_signal(Shome_lisp,SRobotError,NIL,NIL);
  return NIL;
}

int DisplayMessage(s)
     char *s;
{
  error_signal(NIL,SRobotError,C_2_L_string(s),NIL);
}

