function rob_ready()
     "Moves the CRS robot to the ready position"
{
  write_cmnd("READY");
};

function rob_move_abs(th1, th2, th3, th4, th5)
     "Move to the absolute position th1, th2, th3, th4, th5. Notice that\n\
the joint angles are not the same with the physical angles."
{
  write_cmnd(sprintf("MA %f, %f, %f, %f, %f",
		     th1*PI/180, th2*PI/180, (-th3+th2)*PI/180,
		     (-th4+(th2-th3))*PI/180, th5*PI/180));
};


function rob_start_up()
     "This procedure helps to start the robot. Tells you what to do and\n\
lets you click the middle button in the second row when done."
{
  printf("Turn robot main power on and press POWER");
  Tk_Button_wait("POWER");
  printf("\nPress orange button (next to big red) and press MOTOR");
  Tk_Button_wait("MOTOR");
  if (!boundp(RobIsOn))
    rob_init()
  else if (!RobIsOn) rob_init();
  printf("\nRobot is going to go limp. Catch it and press CATCH");
  Tk_Button_wait("CATCH");
  write_cmnd("LIMP 0");
  printf("\nAlign the arrows on the robot joints and tell someone else to press\
ALIGN");
  Tk_Button_wait("ALIGN");
  write_cmnd("NOLIMP 0");
  printf("\nGO AWAY and press AWAY");
  Tk_Button_wait("AWAY");
  Tcl_Eval("update idletasks");	/* Makes the image appear immediately */
  Tcl_Eval("update");
  sleep(5);
  Tcl_Eval("update idletasks");	/* Makes the image appear immediately */
  Tcl_Eval("update");
  write_cmnd("HOME");
  sleep(10);
  Tcl_Eval("update idletasks");	/* Makes the image appear immediately */
  Tcl_Eval("update");
  write_cmnd("READY");
};

function rob_connect()
     "Opens the serial port to communicate with the robot arm and sets some \
defaults"
{
  rob_init();
};

function rob_disconnect()
     "Closes the connection"
{
  rob_quit();
};

function rob_speed(speed)
     "Set the speed as long as it is not that high"
{
  NIL;
};

function send_command(command)
     "Send a <set curtag red>non motion<set curtag reg> command string to \
the arm. Non-motion commands do not wait for the motion to complete. \
They simply write the command and swallow all output from the serial port. \
Motion commands should use <set curtag See>send motioncommand<set curtag reg>."
{
  local res, comlen;

  res = write_cmnd(command);
  res;
};

function send_motioncommand(command)
     "Send a <set curtag red>motion<set curtag reg> command string to the \
arm. This executes the requested command, and then executes a \
joint 1,0 command to move joint 1 by 0 degrees. We then wait until \
this second command returns. Non motion commands should use \
<set curtag See>send_command<set curtag reg>."
{
  local res;
  res = send_command(command);
  sleep(10);
  res;
};

