package A1Q3S;
import java.util.*;

/**
 * Specializes the stack data structure for comparable elements, and provides
 * a method for determining the maximum element on the stack in O(1) time.
 * @author jameselder
 * @param <E> 
 */
public class MaxStack<E extends Comparable<E>> extends Stack<E> {

    private final Stack<E> maxStack;

    public MaxStack() {
        maxStack = new Stack<>();
    }

    @Override
    public E push(E element) {
        super.push(element);
        if (maxStack.empty() || element.compareTo(maxStack.peek()) >= 0) {
            maxStack.push(element); /*element is a maximum - push on maxStack
        }
        return element;
    }

    /* @exception  EmptyStackException  if this stack is empty. */
    @Override
    public synchronized E pop()  throws EmptyStackException {
        E element;
        element = super.pop();
        if (element.equals(maxStack.peek()))
            maxStack.pop(); /*element is a maximum - pop off maxStack
        return element;
    }

    /* Returns the maximum value currently on the stack. */
    /* @exception  EmptyStackException  if this stack is empty. */
    public synchronized E max() throws EmptyStackException {
        return maxStack.peek();
    }
}
