/*
 * Decompiled with CFR 0.152.
 */
package eecs2030.lab4;

public final class Vector2 {
    private double x;
    private double y;

    public Vector2() {
        this(0.0, 0.0);
    }

    public Vector2(double x, double y) {
        this.set(x, y);
    }

    public Vector2(Vector2 other) {
        this(other.getX(), other.getY());
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2 add(Vector2 other) {
        this.setX(this.getX() + other.getX());
        this.setY(this.getY() + other.getY());
        return this;
    }

    public Vector2 subtract(Vector2 other) {
        this.setX(this.getX() - other.getX());
        this.setY(this.getY() - other.getY());
        return this;
    }

    public Vector2 multiply(double s) {
        this.setX(this.getX() * s);
        this.setY(this.getY() * s);
        return this;
    }

    public double mag() {
        return Math.hypot(this.getX(), this.getY());
    }

    public static Vector2 add(Vector2 a, Vector2 b) {
        Vector2 result = new Vector2(a);
        result.add(b);
        return result;
    }

    public static Vector2 subtract(Vector2 a, Vector2 b) {
        Vector2 result = new Vector2(a);
        result.subtract(b);
        return result;
    }

    public static Vector2 multiply(double s, Vector2 a) {
        Vector2 result = new Vector2(a);
        result.multiply(s);
        return result;
    }

    public static Vector2 dirVector(double theta) {
        double radians = Math.toRadians(theta);
        return new Vector2(Math.cos(radians), Math.sin(radians));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector2 other = (Vector2)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ")";
    }

    public boolean similarTo(Vector2 other, double tol) {
        Vector2 delta = Vector2.subtract(this, other);
        return delta.mag() < Math.abs(tol);
    }
}

