/*
 * Decompiled with CFR 0.152.
 */
package eecs2030.lab4;

import eecs2030.lab4.Vector2;

public class Point2 {
    private double x;
    private double y;

    public Point2() {
        this.set(0.0, 0.0);
    }

    public Point2(double newX, double newY) {
        this.set(newX, newY);
    }

    public Point2(Point2 other) {
        this(other.x, other.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double newX) {
        this.x = newX;
    }

    public void setY(double newY) {
        this.y = newY;
    }

    public void set(double newX, double newY) {
        this.x = newX;
        this.y = newY;
    }

    public Point2 add(Vector2 v) {
        this.x += v.getX();
        this.y += v.getY();
        return this;
    }

    public static Vector2 subtract(Point2 a, Point2 b) {
        Vector2 result = new Vector2(a.getX() - b.getX(), a.getY() - b.getY());
        return result;
    }

    public String toString() {
        String s = String.format("(%s, %s)", this.getX(), this.getY());
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point2 other = (Point2)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public boolean similarTo(Point2 other, double tol) {
        Vector2 delta = Point2.subtract(this, other);
        return delta.mag() < Math.abs(tol);
    }
}

