/*
 * Decompiled with CFR 0.152.
 */
package eecs2030.lab4;

public class BlockGrid {
    private int size;
    private boolean[][] grid;

    public BlockGrid(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("grid size must be 1 or greater");
        }
        this.size = n;
        this.grid = new boolean[n][n];
        this.clearAll();
    }

    public final void clearAll() {
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                this.grid[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean get(int row, int col) {
        this.checkRange(row, col);
        return this.grid[row][col];
    }

    public void set(int row, int col) {
        this.checkRange(row, col);
        this.grid[row][col] = true;
    }

    public void clear(int row, int col) {
        this.checkRange(row, col);
        this.grid[row][col] = false;
    }

    private void checkRange(int row, int col) {
        if (row < 0 || row >= this.size) {
            throw new IndexOutOfBoundsException("row is out of range: " + row + " on a grid of size: " + this.size);
        }
        if (col < 0 || col >= this.size) {
            throw new IndexOutOfBoundsException("col is out of range: " + col + " on a grid of size: " + this.size);
        }
    }
}

