/*
 * Decompiled with CFR 0.152.
 */
package franck.cse1020;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Grid
extends JFrame {
    private MyJPanel panel = new MyJPanel();
    private Color[][] colors;
    private int columns;
    private int rows;
    private static int SIZE = 100;

    public Grid(int n) {
        this(n, 1);
    }

    public Grid(int n, int n2) {
        super("Grid");
        this.panel.setPreferredSize(new Dimension(n * SIZE, n2 * SIZE));
        this.add(this.panel);
        this.colors = new Color[n][n2];
        this.columns = n;
        this.rows = n2;
    }

    public void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void set(int n, int n2, Color color) {
        this.colors[n][n2] = color;
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void set(int n, Color color) {
        this.colors[n][0] = color;
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    private class MyJPanel
    extends JPanel {
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            for (int i = 0; i < Grid.this.columns; ++i) {
                for (int j = 0; j < Grid.this.rows; ++j) {
                    if (Grid.this.colors[i][j] == null) continue;
                    graphics.setColor(Grid.this.colors[i][j]);
                    graphics.fill3DRect(i * SIZE, j * SIZE, SIZE, SIZE, true);
                }
            }
        }
    }
}

