/*
 * Decompiled with CFR 0.152.
 */
package franck.cse1020;

public class Fraction {
    private long numer;
    private long denom;
    private static final long serialVersionUID = 1L;

    public Fraction() {
        this(0L, 1L);
    }

    public Fraction(long l, long l2) {
        this.numer = l;
        this.denom = l2;
    }

    public void add(Fraction fraction) {
        if (this.denom == 0L || fraction.getDenominator() == 0L) {
            this.numer = this.numer * fraction.getDenominator() + fraction.getNumerator() * this.denom;
            this.denom *= fraction.getDenominator();
        } else {
            long l = Fraction.lcm(this.denom, fraction.getDenominator());
            this.numer = this.numer * (l / this.denom) + fraction.getNumerator() * (l / fraction.getDenominator());
            this.denom = l;
            this.reduce();
        }
    }

    public void subtract(Fraction fraction) {
        Fraction fraction2 = new Fraction(-fraction.getNumerator(), fraction.getDenominator());
        this.add(fraction2);
    }

    public void multiply(Fraction fraction) {
        this.numer *= fraction.numer;
        this.denom *= fraction.denom;
        this.reduce();
    }

    public void divide(Fraction fraction) {
        Fraction fraction2 = new Fraction(fraction.denom, fraction.numer);
        this.multiply(fraction2);
    }

    public void setNumerator(long l) {
        this.numer = l;
    }

    public long getNumerator() {
        return this.numer;
    }

    public void setDenominator(long l) {
        this.denom = l;
    }

    public long getDenominator() {
        return this.denom;
    }

    public String toString() {
        if (this.denom == 0L) {
            return "NaF";
        }
        return "" + this.numer + '/' + this.denom;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object.getClass() == this.getClass()) {
            Fraction fraction = (Fraction)object;
            bl = this.getNumerator() * fraction.getDenominator() - this.getDenominator() * fraction.getNumerator() == 0L;
        }
        return bl;
    }

    public int hashCode() {
        int n = 23;
        return (int)(this.getNumerator() + 23L * this.getDenominator());
    }

    private void reduce() {
        long l = this.getNumerator();
        long l2 = this.getDenominator();
        if (l == 0L || l2 == 0L) {
            return;
        }
        long l3 = Fraction.euc(l, l2);
        this.numer /= l3;
        this.denom /= l3;
    }

    private static long lcm(long l, long l2) {
        return l * l2 / Fraction.euc(l, l2);
    }

    private static long euc(long l, long l2) {
        long l3;
        if (l == 0L || l2 == 0L) {
            return 1L;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l < l2) {
            l3 = l2;
            l2 = l;
            l = l3;
        }
        l3 = l % l2;
        while (l3 != 0L) {
            l = l2;
            l2 = l3;
            l3 = l % l2;
        }
        return l2;
    }
}

