package gameComponents;

import java.awt.Point;

/**
 * This class encapsulates a circle, centered at the origin (0,0) that has a
 * single point located somewhere on the circumference.
 * 
 * @author mb
 * 
 */
public class UtilityCircle {
	private double diameter;
	private Point pointOnCircumference;
	private double angularDisplacementOfP1; // angular displacement of 0 is when
											// point is directly above centre
											// point

	/**
	 * Constructs a circle with centre point at 0,0 and whose circumference is
	 * given by the passed diameter value. Place a point on the circumference at
	 * the specified angular displacement.
	 * 
	 * @param angularDisplacement
	 * @param diameter
	 */
	public UtilityCircle(double angularDisplacement, double diameter) {
		this.diameter = diameter;
		// this.angularDisplacementOfP1 = angularDisplacement % (2 * Math.PI);
		this.angularDisplacementOfP1 = angularDisplacement;
		double x = 0;
		double y = 0;
		x = Math.sin(getAngle()) * diameter;
		y = -Math.cos(getAngle()) * diameter;

		pointOnCircumference = new Point((int) x, (int) y);
	}

	/**
	 * Constructs a circle with centre point at 0,0 and whose circumference
	 * passes through the passed point
	 * 
	 * @param p1
	 */
	public UtilityCircle(Point p1) {
		p1.y = p1.y;
		this.pointOnCircumference = p1;
		angularDisplacementOfP1 = Math.atan(p1.getX() / p1.getY());
		diameter = Math.sqrt(Math.pow(p1.getX(), 2) + Math.pow(p1.getY(), 2));
	}

	public void addPointOnCircumference(Point p) {
		this.pointOnCircumference = p;

	}

	/**
	 * Returns x displacement of p1, as measured in a horizontal line starting
	 * at the vertical line passing through the centre point, of p1
	 * 
	 * @return as described above
	 */
	public double getXDisplacement() {
		return diameter * Math.sin(getAngle());
	}

	/**
	 * Returns y displacement of p1, as measured in a vertical line starting at
	 * the horizontal line passing through the centre point, of p1
	 * 
	 * @return as described above
	 */
	public double getYDisplacement() {
		return diameter * Math.cos(getAngle());
	}

	/**
	 * Returns diameter of this circle
	 * 
	 * @return as described above
	 */
	public double getDiameter() {
		return diameter;
	}

	/**
	 * returns the angle of the trajectory that travels through the point
	 * 
	 * @return as described above
	 */
	public double getAngle() {
		return angularDisplacementOfP1 % (2 * Math.PI);
	}

	public Point getPointOnCircumference() {
		return pointOnCircumference;
	}

}
