package gameComponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class TargetSprite implements Sprite {

	private final int MARGIN_BUFFER = 150;
	private Shape theShape;
	// the anchor point of the bounding box.
	private int width;
	private int height;

	private int pointsValueIfHit;
	private Color theColour;
	private int targetSize;

	private boolean isHit = false;

	private Random randomGenerator = new Random();

	/**
	 * Constructs a sprite located at the 0,0 position
	 * 
	 * @param dimensionOfDrawingRegion
	 */
	public TargetSprite(Dimension dimensionOfDrawingRegion) {
		width = dimensionOfDrawingRegion.width;
		height = dimensionOfDrawingRegion.height;

		Point2D p = getRandomPositionAtTopOfScreen();

		int index = randomGenerator.nextInt(TargetServices
				.getNumberOfPossibleTargets());

		pointsValueIfHit = TargetServices.getPointsForIndex(index);

		// determine the size of this target. Use the value for the diameter of
		// the circle.
		targetSize = TargetServices.getSizeForIndex(index);

		theColour = TargetServices.getColorForIndex(index);

		isHit = false;

		theShape = new Ellipse2D.Double(p.getX(), p.getY(), targetSize,
				targetSize);

	}

	/**
	 * Accessor for this sprite's current x position
	 * 
	 * @return as specified above
	 */
	public int getCurrentX() {
		return (int) getBounds2D().getX();
	}

	/**
	 * Accessor for this sprite's current y position
	 * 
	 * @return as specified above
	 */
	public int getCurrentY() {
		return (int) getBounds2D().getY();
	}

	/**
	 * This method takes the passed Graphics2D object and specifies how this
	 * sprite should be drawn on it.
	 */
	public void specifyDrawing(Graphics2D g) {
		// Render this sprite
		if (!isHit) {
			g.setColor(theColour);
			g.fill(theShape);
		}
	}

	/**
	 * This method returns the width of the bounding box that contains this
	 * sprite. If this sprite has not yet been drawn, the bounding box cannot
	 * yet be known and then this method returns null
	 * 
	 * @return as described above
	 */
	public int getWidth() {
		return (int) theShape.getBounds2D().getWidth();
	}

	/**
	 * This method returns a rectangular box that completely encloses this
	 * sprite. The bounding box can be assumed to be the smallest bounding box
	 * that is possible.
	 * 
	 * @return as described above
	 */
	@Override
	public Rectangle2D getBounds2D() {
		return theShape.getBounds2D();
	}

	/**
	 * This method returns the height of the bounding box that contains this
	 * sprite
	 * 
	 * @return as described above
	 */
	public int getHeight() {
		return (int) theShape.getBounds2D().getHeight();
	}

	public boolean isCollided(Sprite s) {
		boolean cond1 = isHit == false;
		boolean cond2 = theShape.intersects(s.getBounds2D().getX(), s
				.getBounds2D().getY(), s.getBounds2D().getWidth(), s
				.getBounds2D().getHeight());
		return cond1 && cond2;
	}

	/**
	 * Causes this sprite to explode. Presently the explosion is very
	 * anti-climatic (it just disappears).
	 * 
	 */
	public void explode() {
		isHit = true;
	}

	private Point2D getRandomPositionAtTopOfScreen() {
		int y = 0;
		// keep the target at least one target width away from the left and
		// right sides

		// ## EXERCISE 1A - I have commented out the statement in the code base

		// random generator returns an int between 0 (inclusive) and the
		// specified parameter value (exclusive)
		// this is the previous statement
		// int x = targetSize + randomGenerator.nextInt(width - 3 * targetSize);

		// ## EXERCISE 1 - would suggest class constant should be used here
		int x = MARGIN_BUFFER
				+ randomGenerator.nextInt(width - (MARGIN_BUFFER + targetSize));
		return new Point2D.Double(x, y);
	}

	/**
	 * Returns the points value awards if this target is hit
	 * 
	 * @return as described above
	 */
	public int getPointsValue() {
		return pointsValueIfHit;
	}

	public String toString() {
		return TargetServices.getColorName(theColour.getRGB()) + "-"
				+ getPointsValue() + " Target";
	}
}
