package gameComponents;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public interface ShooterSprite extends Sprite {

	/**
	 * This method takes the passed Graphics2D object and specifies how this
	 * sprite should be drawn on it.
	 */
	public abstract void specifyDrawing(Graphics2D g);

	/**
	 * Move this sprite up one "vertical unit" (the size of this unit is
	 * determined by a class attribute).
	 */
	public abstract void moveUp();

	/**
	 * Move this sprite down one "vertical unit" (the size of this unit is
	 * determined by a class attribute).
	 */
	public abstract void moveDown();

	/**
	 * Move this sprite left one "horizontal unit" (the size of this unit is
	 * determined by a class attribute).
	 */
	public abstract void moveLeft();

	/**
	 * Move this sprite right one "horizontal unit" (the size of this unit is
	 * determined by a class attribute).
	 */
	public abstract void moveRight();

	/**
	 * Position this sprite in the initial location.
	 */
	public abstract void setInitialLocation();

	/**
	 * Method creates a ProjectileSprite located at tip of this shooter.
	 */
	public abstract ProjectileSprite fire();

	public abstract void rotateRight();

	public abstract void rotateLeft();
}