package gameComponents;

/**
 * This interface encapsulates a listener for a data model (that would be part
 * of a model-view-controller architecture)
 * 
 * @author mb
 * 
 */
public interface ModelListener {

	/**
	 * Method that is invoked when this listener wishes to respond or to react
	 * to a change that originated in whichever object this listener is
	 * listening to. In this version of the listener, the interface stipulates
	 * precisely what this object is.
	 */
	public void changed();

}
