package gameComponents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class Controller implements KeyListener, ActionListener {

	private SpriteDataModel theModel;
	boolean shouldMoveShooterUp = false;
	boolean shouldMoveShooterDown = false;
	boolean shouldMoveShooterLeft = false;
	boolean shouldMoveShooterRight = false;
	boolean shouldFire = false;

	public Controller(GameCanvas gameCanvas, SpriteDataModel theModel) {
		this.theModel = theModel;
		gameCanvas.addKeyListener(this);
	}

	@Override
	public void keyPressed(KeyEvent e) {
		int code = e.getKeyCode();
		boolean setFlag = true;
		switch (code) {
		case KeyEvent.VK_UP:
			shouldMoveShooterUp = setFlag;
			break;
		case KeyEvent.VK_DOWN:
			shouldMoveShooterDown = setFlag;
			break;
		case KeyEvent.VK_LEFT:
			shouldMoveShooterLeft = setFlag;
			break;
		case KeyEvent.VK_RIGHT:
			shouldMoveShooterRight = setFlag;
			break;
		case KeyEvent.VK_SPACE:
			shouldFire = setFlag;
			break;
		}
	}

	@Override
	public void keyReleased(KeyEvent e) {
		int code = e.getKeyCode();
		boolean setFlag = false;
		switch (code) {
		case KeyEvent.VK_UP:
			shouldMoveShooterUp = setFlag;
			break;
		case KeyEvent.VK_DOWN:
			shouldMoveShooterDown = setFlag;
			break;
		case KeyEvent.VK_LEFT:
			shouldMoveShooterLeft = setFlag;
			break;
		case KeyEvent.VK_RIGHT:
			shouldMoveShooterRight = setFlag;
			break;
		case KeyEvent.VK_SPACE:
			shouldFire = setFlag;
			break;
		}
	}

	@Override
	public void keyTyped(KeyEvent e) {
		// do nothing
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {

		if (shouldFire)
			theModel.fireShooter();

		if (shouldMoveShooterUp) {
			theModel.getShooterSprite().moveUp();
		} else if (shouldMoveShooterDown) {
			theModel.getShooterSprite().moveDown();
		} else if (shouldMoveShooterLeft) {
			//theModel.getShooterSprite().moveLeft();
			// EXERCISE #3
			 theModel.getShooterSprite().rotateRight();
		} else if (shouldMoveShooterRight) {
			//theModel.getShooterSprite().moveRight();
			// EXERCISE #3
			 theModel.getShooterSprite().rotateLeft();
		}

		theModel.updateSprites();
	}

}
