
import gameComponents.GameCanvas;
import gameComponents.Controller;
import gameComponents.SpriteDataModel;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;

import javax.swing.SwingUtilities;
import javax.swing.Timer;

/**
 * This app launches our shooter game (which is not really functional at this
 * point). This app launches the game in a CORRECT. It is provided here for
 * illustration and teaching purposes.
 * 
 * @author mb
 * 
 */
public class GameDriver {

	/**
	 * @param args
	 *            no command-line args are understood by this app
	 * @throws InvocationTargetException
	 * @throws InterruptedException
	 */
	public static void main(String[] args) throws InterruptedException,
			InvocationTargetException {

		Runnable gameRunnable = new Runnable() {
			public void run() {
				launchGame();
			}
		};

		SwingUtilities.invokeAndWait(gameRunnable);

	}

	public static void launchGame() {

		Frame theGameWindow = new Frame();
		theGameWindow.setUndecorated(true);
		Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
		int halfScreenWidth = screenDimension.width / 2;
		int halfScreenHeight = screenDimension.height / 2;
		Dimension dim = new Dimension(halfScreenWidth, halfScreenHeight);

		SpriteDataModel theModel = new SpriteDataModel(dim);
		GameCanvas theCanvas = new GameCanvas(dim, theModel);

		theGameWindow.add(theCanvas);
		theGameWindow.setMinimumSize(dim);
		theGameWindow.pack();
		theGameWindow.setVisible(true);
		theCanvas.createBufferStrategy(2);
		
		Controller controller = new Controller(theCanvas, theModel);


		final int NUM_MSEC_PER_SEC = 1000;
		// change this value to indicate the desired number of frames per second
		final int NUM_FRAME_PER_SEC = 30;
		// here we determine how much time each frame should spend on-screen
		int msecPerFrame = NUM_MSEC_PER_SEC / NUM_FRAME_PER_SEC;
		Timer frameAdvancerTimer = new Timer(msecPerFrame, controller);
		frameAdvancerTimer.start();

		theCanvas.requestFocus();

		PrintStream output = System.out;
		output.println("Commands: space (fire)");


	}

}