package utility;

import img.Picture;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.util.Collection;

import com.cycling74.max.MaxObject;

/**
 * This class encapsulates a graphical animation that provides a visualization
 * of a single particle moving around a space. The visualization relies on the
 * client to dictate the position of the particle. The animation is driven by
 * the client successively updating the particle's position.
 * 
 * @author mb
 * 
 */
public class Visualizer extends MaxObject {

	private Picture myPict;
	private PrintStream output = System.out;
	private Shape theTrackPoint;
	private Point origin = new Point(0, 0);
	private int PARTICLE_DIAMETER = 5;
	private Color theColor = Color.BLACK;

	public Visualizer(int horizontalDimension, int verticalDimension) {
		myPict = new Picture(horizontalDimension, verticalDimension);
		myPict.show();
	}

	/**
	 * Specify the next position of the particle and redraw the canvas.
	 * 
	 * @param p
	 *            the next position of the particle.
	 */
	public void inlet(Point p) {
		Graphics2D graphicsObj = myPict.getGraphics2D();
		theTrackPoint = new Ellipse2D.Double(p.x, p.y, PARTICLE_DIAMETER,
				PARTICLE_DIAMETER);
		graphicsObj.setPaint(theColor);
		graphicsObj.fill(theTrackPoint);
		myPict.repaint();
	}

	public void setColor(Color c) {
		theColor = c;
	}

	/**
	 * Returns a color from the spectrum that spans from red to violet. A value
	 * of 0 returns red. The intermediate values span red, orange, yellow,
	 * green, blue, indigo. A value of 1 returns reddish-indigo (but mostly
	 * reddish).
	 * 
	 * Hue angle in the HSV color model ranges over [0,2*Math.PI] in radians or
	 * [0,360] in degrees. See the HSV model illustration in wikipedia entry
	 * [http://en.wikipedia.org/wiki/HSL_and_HSV]. This method accepts a value
	 * over the interval [0,1].
	 * 
	 * @param normalizedHueAngle
	 *            a float on the closed interval [0,1]
	 * @return a color, as described above
	 */
	public static Color chooseColorFromSpectrum(float normalizedHueAngle) {
		return new Color(Color.HSBtoRGB(normalizedHueAngle, 1, 1));
	}
}
