package img;

/**
 * Picture class from Guzdial and Ericson with explanatory comments enhanced by
 * sdc@cs.albany.edu
 * 
 * A class that represents a picture. This class inherits from SimplePicture and
 * allows the student to add functionality to the Picture class.
 * 
 * Copyright Georgia Institute of Technology 2004-2005
 * 
 * @author Barbara Ericson ericson@cc.gatech.edu
 */
public class Picture extends SimplePicture {
	// /////////////////// constructors //////////////////////////////////

	/**
	 * Constructor that takes no arguments
	 */
	public Picture() {
		/*
		 * The constructor with no arguments is called the default constructor.
		 * 
		 * It need not be coded but Guzdial and Ericson included it to show
		 * students the implicit call to super().
		 * 
		 * In Java, every constructor must alway call a parent constructor. If
		 * the programmer doesn't code such a call explicitly, the Java compiler
		 * adds the call super().
		 */
		super();
	}

	/**
	 * In Java, constructors (and other methods) can be "Polymorphic".
	 * Polymorphic methods have the SAME NAME but MULTIPLE FORMS. Each form has
	 * a really different body. Which body is called depends on the types of
	 * arguments coded in the call.
	 * 
	 * Here is a second polymorphic form for Picture's constructor. Constructor
	 * that takes a file name and creates the picture
	 * 
	 * @param fileName
	 *            the name of the file to create the picture from
	 */
	public Picture(String fileName) {
		// let the parent class handle this fileName
		// The Picture class "inherits" the form of constructor
		// from the SimplePicture class that takes a String argument.
		// That constructor of SimplePicture initializes the image
		// from the file named by the String argument fileName.
		super(fileName);
	}

	/**
	 * Wow, a third form of constructor! Constructor that takes the width and
	 * height
	 * 
	 * @param width
	 *            the width of the desired picture
	 * @param height
	 *            the height of the desired picture
	 */
	public Picture(int width, int height) {
		// let the parent class handle this width and height
		super(width, height);
	}

	/**
	 * Whoops, yet another! Constructor that takes a picture and creates a copy
	 * of that picture
	 */
	public Picture(Picture copyPicture) {
		// let the parent class do the copy
		super(copyPicture);
	}

	/**
	 * And one more! Consult the Java API for information about a BufferedImage.
	 * This constuctor lets you use Guzdial and Ericson's Picture class with
	 * images within more professional applications that use Java's library
	 * image facilities. Constructor that takes a buffered image
	 * 
	 * @param image
	 *            the buffered image to use
	 */
	// public Picture(BufferedImage image) {
	// super(image);
	// }

	// //////////////////// methods ///////////////////////////////////////

	/**
	 * This method DOES NOT (yes, NOT) PRINT anything! What code could a program
	 * using the Picture class have to use this method to print a string form of
	 * a Picture?
	 * 
	 * Method to return a string with information about this picture.
	 * 
	 * @return a string with information about the picture such as fileName,
	 *         height and width.
	 */
	public String toString() {
		String output = "Picture, filename " + getFileName() + " height "
				+ getHeight() + " width " + getWidth();
		return output;

	}

	// /// Here is where you should put the methods you
	// /// write to solve programming problems as presented
	// /// in Chapter 5 of Guzdial and Ericson's book.

	// /// In that book, the Picture class is used in
	// /// TWO DIFFERENT WAYS at once!
	// /// Way 1: It is the container for an application program.
	// /// The program performs the operations coded in main()
	// /// when the program is run.
	// /// Way 2: The Picture class is a "cookie cutter" for
	// /// Picture objects. My previous demonstration program
	// /// uses the Picture class in Way 2 only.

	// // The Guzdial/Ericson style for developing new code:
	// // (1) Run the Picture program in Dr. Java so the Picture
	// // class is available in the Interactions window.
	// // (2) Learn and experiment by using the Interactions
	// // window like a calculator. (See the book for examples.)
	// // (3) Eventually, edit new methods into the Picture class.
	// // (4) Test your new methods from the Interactions window:
	// // (a) (say) Picture p1 = new Picture(...)
	// // (b) p1.myNewMethod(...) //Call your new method.
	// // (c) p1.show(..) or p1.repaint( ) //See its effects.

	// // The example below shows how my new method (blacken)
	// // is used by the complete Java application. A Picture
	// // is instantiated by main() and then main() calls the
	// // blacken method on that Picture.

	public void blacken(int row) {
		for (int i = 0; i < this.getWidth(); i++) {
			Pixel p = getPixel(i, row);
			p.setRed(0);
			p.setGreen(0);
			p.setBlue(0);
			this.repaint();
		}
	}

	// public static void main(String[] args) {
	// String fileName = FileChooser.pickAFile();
	// Picture pictObj = new Picture(fileName);
	// pictObj.explore();
	// pictObj.blacken(3);
	// }

} // this } is the end of class Picture, put all new methods before this
