import java.awt.Point;
import java.io.PrintStream;

import utility.TrajectoryGenerator;
import utility.Visualizer;

/**
 * This app drives an animation of a particle as it meanders around a canvas.
 * 
 * @author mb
 * 
 */
public class AppDriver {

	public static void main(String[] args) {
		PrintStream output = System.out;

		// this app drives an animation, the duration of which is determined by
		// the value of this constant
		final int ANIMATION_DURATION_IN_SECONDS = 30;
		// the animation will be shown on a canvas whose dimensions are
		// determined by these values
		final int CANVAS_WIDTH = 500;
		final int CANVAS_HEIGHT = 500;

		// the animation will have a certain number of frames per second. The
		// number of frames per second is determined by the value of this
		// constant.
		final int FRAMES_PER_SECOND = 60;

		final int NUM_MSEC_PER_SEC = 1000;

		// this derivation determines how much time elapses between frames
		final int pauseBetweenFrames = NUM_MSEC_PER_SEC / FRAMES_PER_SECOND;

		// these have been instantiated for you; you will use these in Step 2.
		Visualizer visualizer = new Visualizer(CANVAS_WIDTH, CANVAS_HEIGHT);
		TrajectoryGenerator trajectoryGenerator = new TrajectoryGenerator(
				CANVAS_WIDTH, CANVAS_HEIGHT);

		int pointCount = 0;

		long startTimeStamp = System.currentTimeMillis();
		long stopTimeStamp = startTimeStamp + ANIMATION_DURATION_IN_SECONDS
				* NUM_MSEC_PER_SEC;

		while (true) {
			if (System.currentTimeMillis() > stopTimeStamp) {
				break;
			}

			double proportionComplete = (System.currentTimeMillis() - startTimeStamp)
					/ (double) (ANIMATION_DURATION_IN_SECONDS * NUM_MSEC_PER_SEC);

			// Another way to derive the proportion complete, but a PROBLEMATIC
			// way
			// double proportionComplete = System.currentTimeMillis()
			// / (double) stopTimeStamp;
			output.printf("%s%.4f%s", "Proportion Complete: ",
					proportionComplete, "\n");

			pointCount++;

			try {
				Thread.sleep(pauseBetweenFrames);
			} catch (InterruptedException e) {
				// an exception is thrown if another thread interrupts the
				// thread on which this main method is running.
				System.exit(0);
			}

		}

		output.println("Done. Num Points: " + pointCount);

	}
}
