/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.net;

import com.cycling74.max.Atom;
import com.cycling74.max.Callback;
import com.cycling74.max.MaxSystem;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class UdpReceiver
implements Runnable {
    private static Class ATOM_ARRAY_CLASS = new Atom[0].getClass();
    private int port;
    private DatagramSocket recvSocket;
    private Thread listener = null;
    private String debugString = "UdpReceiver";
    private Callback callback;

    public UdpReceiver(int port) {
        this.port = port;
        this.setActive(true);
    }

    public UdpReceiver() {
    }

    public void setPort(int port) {
        this.port = port;
        this.resetListener();
    }

    public int getPort() {
        return this.port;
    }

    private void resetListener() {
        new Thread(){

            public void run() {
                UdpReceiver.this.setListener(false);
                UdpReceiver.this.setListener(true);
            }
        }.start();
    }

    public void setDebugString(String s) {
        this.debugString = s;
    }

    public void setActive(boolean b) {
        if (b) {
            new Thread(){

                public void run() {
                    UdpReceiver.this.setListener(true);
                }
            }.start();
        } else {
            new Thread(){

                public void run() {
                    UdpReceiver.this.setListener(false);
                }
            }.start();
        }
    }

    private void setListener(boolean b) {
        if (b) {
            if (this.listener == null && this.initRecvSocket()) {
                this.listener = new Thread(this);
                this.listener.start();
            }
        } else {
            if (this.recvSocket != null) {
                this.recvSocket.close();
            }
            this.listener = null;
        }
    }

    private boolean initRecvSocket() {
        try {
            this.recvSocket = new DatagramSocket(this.port);
            return true;
        }
        catch (BindException be) {
            MaxSystem.error(this.debugString + ": there is already an object bound to port " + this.port);
        }
        catch (SocketException se) {
            MaxSystem.error(this.debugString + ": socket exception: " + se);
        }
        return false;
    }

    public void run() {
        try {
            while (true) {
                byte[] buf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.recvSocket.receive(packet);
                this.callback.setArgs(new Object[]{Atom.parse(new String(packet.getData(), 0, packet.getLength()), false)});
                this.callback.execute();
            }
        }
        catch (IOException ie) {
            return;
        }
    }

    public void setCallback(Object toCallIn, String methodName) {
        this.callback = new Callback(toCallIn, methodName, new Object[]{new Atom[0]});
    }

    public void close() {
        this.setActive(false);
    }
}

