/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.net;

import com.cycling74.max.Atom;
import com.cycling74.max.Callback;
import com.cycling74.max.MaxSystem;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class TcpSender {
    private InetAddress iAddress = null;
    private String address = null;
    private int port = 0;
    private boolean goodParams = false;
    private String debugString = "TcpSender";
    private Callback successCallback = null;
    private Callback failureCallback = null;
    private int activePackets = 0;

    public TcpSender(String address, int port) {
        this.setAddress(address);
        this.setPort(port);
    }

    public TcpSender() {
    }

    private void initSendSocket(String addrarg, int portarg) {
        if (addrarg != null && portarg != 0) {
            try {
                this.goodParams = false;
                this.iAddress = InetAddress.getByName(addrarg);
                this.port = portarg;
                this.goodParams = true;
            }
            catch (UnknownHostException uhe) {
                MaxSystem.error(this.debugString + ": unknown host: " + addrarg);
            }
        }
    }

    public void setSuccessCallback(Object toCallIn, String methodName) {
        if (toCallIn != null && methodName != null) {
            this.successCallback = new Callback(toCallIn, methodName, new Object[]{Atom.emptyArray});
        }
    }

    public void setFailureCallback(Object toCallIn, String methodName) {
        if (toCallIn != null && methodName != null) {
            this.failureCallback = new Callback(toCallIn, methodName, new Object[]{Atom.emptyArray});
        }
    }

    public void setAddress(String address) {
        this.address = address;
        this.initSendSocket(address, this.port);
    }

    public String getAddress() {
        return this.address;
    }

    public void setPort(int port) {
        this.port = port;
        this.initSendSocket(this.address, port);
    }

    public void setDebugString(String debugString) {
        this.debugString = debugString;
    }

    public int getPort() {
        return this.port;
    }

    public int getActivePackets() {
        return this.activePackets;
    }

    public void send(int i) {
        this.send(new Integer(i).toString());
    }

    public void send(float f) {
        this.send(new Float(f).toString());
    }

    public void send(String msg, Atom[] a) {
        this.send(msg + " " + Atom.toOneString(a));
    }

    public void send(Atom[] a) {
        this.send(Atom.toOneString(a));
    }

    private void send(String s) {
        if (this.goodParams) {
            Sender sd = new Sender(s);
            sd.start();
        }
    }

    public void close() {
        this.successCallback = null;
        this.failureCallback = null;
    }

    private class Sender
    extends Thread {
        private String s;

        Sender(String s) {
            TcpSender.this.activePackets++;
            this.s = s;
        }

        public void run() {
            try {
                Socket sendSocket = new Socket(TcpSender.this.iAddress, TcpSender.this.port);
                PrintWriter writer = new PrintWriter(sendSocket.getOutputStream());
                writer.println(this.s);
                writer.close();
                TcpSender.this.activePackets--;
                if (TcpSender.this.successCallback != null) {
                    TcpSender.this.successCallback.setArgs(new Object[]{Atom.parse(this.s)});
                    TcpSender.this.successCallback.execute();
                }
            }
            catch (SocketException se) {
                TcpSender.this.activePackets--;
                if (TcpSender.this.failureCallback != null) {
                    TcpSender.this.failureCallback.setArgs(new Object[]{Atom.parse(this.s)});
                    TcpSender.this.failureCallback.execute();
                } else {
                    MaxSystem.error(TcpSender.this.debugString + ": socket exception: " + se);
                    MaxSystem.post("not sent: " + this.s);
                }
            }
            catch (IOException ie) {
                TcpSender.this.activePackets--;
                if (TcpSender.this.failureCallback != null) {
                    TcpSender.this.failureCallback.setArgs(new Object[]{Atom.parse(this.s)});
                    TcpSender.this.failureCallback.execute();
                }
                MaxSystem.error(TcpSender.this.debugString + ": io exception: " + ie);
                MaxSystem.post("not sent: " + this.s);
            }
        }
    }
}

