/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.net;

import com.cycling74.max.Atom;
import com.cycling74.max.MaxSystem;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class MultiSender {
    private InetAddress group = null;
    private String groupName;
    private String debugString;
    private int port;
    private int timeToLive;
    private MulticastSocket sendSocket = null;
    private boolean readyToSend = false;
    private boolean validGroup = false;
    private boolean validPort = false;

    public MultiSender(String groupName, int port, String debugString, byte timeToLive) {
        this.setDebugString(debugString);
        this.setTimeToLive(timeToLive);
        if (port > 0) {
            this.setPort(port);
        }
        if (groupName != null) {
            this.setGroup(groupName);
        }
        this.init();
    }

    public MultiSender(String groupName, int port, byte timeToLive) {
        this(groupName, port, "MultiSender", timeToLive);
    }

    public MultiSender(String groupName, int port) {
        this(groupName, port, 1);
    }

    public MultiSender() {
        this(null, 0);
    }

    public void setPort(int p) {
        this.port = p;
        this.validPort = true;
    }

    public int getPort() {
        return this.port;
    }

    public void setGroup(String s) {
        this.groupName = s;
        new Thread(){

            public void run() {
                try {
                    MultiSender.this.validGroup = false;
                    MultiSender.this.group = InetAddress.getByName(MultiSender.this.groupName);
                    MultiSender.this.validGroup = true;
                }
                catch (UnknownHostException uhe) {
                    MaxSystem.error(MultiSender.this.debugString + ": unknown group. " + uhe);
                }
            }
        }.start();
    }

    public String getGroup() {
        return this.groupName;
    }

    public void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public byte getTimeToLive() {
        return (byte)this.timeToLive;
    }

    public void setDebugString(String s) {
        this.debugString = s;
    }

    private void init() {
        new Thread(){

            public void run() {
                try {
                    MultiSender.this.readyToSend = false;
                    MultiSender.this.sendSocket = new MulticastSocket();
                    MultiSender.this.readyToSend = true;
                }
                catch (IOException ioe) {
                    MaxSystem.error(MultiSender.this.debugString + ": io error." + ioe);
                }
            }
        }.start();
    }

    private void send(String msg) {
        if (this.readyToSend && this.validGroup && this.validPort) {
            DatagramPacket packet = new DatagramPacket(msg.getBytes(), msg.length(), this.group, this.port);
            try {
                int oldTtl = this.sendSocket.getTimeToLive();
                this.sendSocket.setTimeToLive(this.timeToLive);
                this.sendSocket.send(packet);
                this.sendSocket.setTimeToLive(oldTtl);
            }
            catch (IOException ioe) {
                MaxSystem.error(this.debugString + ": io error." + ioe);
            }
        } else {
            MaxSystem.error(this.debugString + "not ready to send.");
        }
    }

    public void send(int i) {
        this.send(new Integer(i).toString());
    }

    public void send(float f) {
        this.send(new Float(f).toString());
    }

    public void send(Atom[] a) {
        this.send(Atom.toOneString(a));
    }

    public void send(String msg, Atom[] a) {
        this.send(msg + " " + Atom.toOneString(a));
    }
}

