/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.net;

import com.cycling74.max.Atom;
import com.cycling74.max.Callback;
import com.cycling74.max.MaxSystem;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;

public class MultiReceiver
implements Runnable {
    private static Class ATOM_ARRAY_CLASS = new Atom[0].getClass();
    private String debugString = "MultiReceiver";
    private int port;
    private boolean active = false;
    private MulticastSocket mRecvSocket;
    private Thread mListener = null;
    private boolean keepRunning;
    private Callback callback = null;
    private Vector addresses = new Vector();

    public MultiReceiver() {
    }

    public MultiReceiver(String groupName, int port, Object toCallIn, String methodName) {
        this.setCallback(toCallIn, methodName);
        this.addAddress(groupName);
        this.setPort(port);
    }

    public MultiReceiver(String groupName, int port) {
        this.addAddress(groupName);
        this.setPort(port);
    }

    public MultiReceiver(int port) {
        this.setPort(port);
    }

    public void setPort(int port) {
        this.port = port;
        this.resetListener();
    }

    public int getPort() {
        return this.port;
    }

    public void setCallback(Object toCallIn, String methodName) {
        this.callback = new Callback(toCallIn, methodName, new Object[]{new Atom[0]});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAddress(String name) {
        Vector vector = this.addresses;
        synchronized (vector) {
            this.addresses.add(name);
        }
    }

    public void setActive(boolean b) {
        if (b) {
            new Thread(){

                public void run() {
                    MultiReceiver.this.setListener(true);
                }
            }.start();
        } else {
            new Thread(){

                public void run() {
                    MultiReceiver.this.setListener(false);
                }
            }.start();
        }
    }

    private void setListener(boolean b) {
        if (b) {
            if (this.mListener == null) {
                this.keepRunning = true;
                if (this.initRecvSocket()) {
                    this.joinAllGroups();
                    this.mListener = new Thread(this);
                    this.mListener.start();
                    this.active = true;
                }
            }
        } else {
            if (this.mListener != null) {
                this.keepRunning = false;
            }
            if (this.mRecvSocket != null) {
                this.mRecvSocket.close();
            }
            this.mListener = null;
            this.active = false;
        }
    }

    private void resetListener() {
        new Thread(){

            public void run() {
                MultiReceiver.this.setListener(false);
                MultiReceiver.this.setListener(true);
            }
        }.start();
    }

    public String[] getGroups() {
        return (String[])this.addresses.toArray(Atom.emptyArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinAllGroups() {
        Vector vector = this.addresses;
        synchronized (vector) {
            Iterator i = this.addresses.iterator();
            while (i.hasNext()) {
                MultiJoiner jl = new MultiJoiner((String)i.next());
                jl.start();
            }
        }
    }

    public void join(String name) {
        this.addAddress(name);
        if (this.active) {
            MultiJoiner jl = new MultiJoiner(name);
            jl.start();
        }
    }

    private boolean initRecvSocket() {
        try {
            this.mRecvSocket = new MulticastSocket(this.port);
        }
        catch (IOException ioe) {
            MaxSystem.error(this.debugString + ": io error. " + ioe);
        }
        return true;
    }

    public void run() {
        byte[] buf = new byte[1024];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        while (this.keepRunning) {
            try {
                this.mRecvSocket.receive(packet);
                if (!this.keepRunning || this.callback == null) continue;
                String s = new String(packet.getData(), 0, packet.getLength());
                this.callback.setArgs(new Object[]{Atom.parse(s)});
                this.callback.execute();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() {
        new Thread(){

            public void run() {
                MultiReceiver.this.leaveAllGroups();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveAllGroups() {
        Vector vector = this.addresses;
        synchronized (vector) {
            Iterator i = this.addresses.iterator();
            while (i.hasNext()) {
                MultiLeaver jl = new MultiLeaver((String)i.next());
                jl.start();
            }
            this.addresses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(String name) {
        boolean found = false;
        Vector vector = this.addresses;
        synchronized (vector) {
            int count = 0;
            Iterator i = this.addresses.iterator();
            while (i.hasNext() && !found) {
                if (((String)i.next()).equals(name)) {
                    found = true;
                    continue;
                }
                ++count;
            }
            if (found) {
                this.addresses.remove(count);
            }
        }
        if (found) {
            MultiLeaver jl = new MultiLeaver(name);
            jl.start();
        }
    }

    public void setDebugString(String name) {
        this.debugString = name;
    }

    private class MultiLeaver
    extends Thread {
        String name;

        MultiLeaver(String name) {
            this.name = name;
        }

        public void run() {
            try {
                InetAddress addr = InetAddress.getByName(this.name);
                MultiReceiver.this.mRecvSocket.leaveGroup(addr);
            }
            catch (UnknownHostException uhe) {
                MaxSystem.error(MultiReceiver.this.debugString + ": unknown host " + this.name + ". " + uhe);
            }
            catch (SocketException se) {
                MaxSystem.error(MultiReceiver.this.debugString + ": socket error. " + se);
                MaxSystem.post("Are you sure you were a member of that group?");
            }
            catch (IOException ie) {
                MaxSystem.error(MultiReceiver.this.debugString + ": io error. " + ie);
            }
        }
    }

    private class MultiJoiner
    extends Thread {
        String name;

        MultiJoiner(String name) {
            this.name = name;
        }

        public void run() {
            try {
                InetAddress addr = InetAddress.getByName(this.name);
                MultiReceiver.this.mRecvSocket.joinGroup(addr);
            }
            catch (UnknownHostException uhe) {
                MaxSystem.error(MultiReceiver.this.debugString + ": unknown host " + this.name + ". " + uhe);
            }
            catch (SocketException se) {
                MaxSystem.error(MultiReceiver.this.debugString + ": socket error. " + se);
                MaxSystem.post("Have you already joined that group?");
            }
            catch (IOException ie) {
                MaxSystem.error(MultiReceiver.this.debugString + ": io error. " + ie);
            }
        }
    }
}

