/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.mxjedit;

import com.cycling74.max.MXJPreferences;
import com.cycling74.mxjedit.MXJEditCompileContext;
import com.cycling74.mxjedit.MXJEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class MXJEditCompileFrame
extends JFrame {
    JTextField tf_cc = null;
    JTextField tf_bd = null;
    JTextField tf_cp = null;
    JTextField tf_sf = null;
    JTextField tf_co = null;
    ColorPane messages = null;
    JButton compile_button = null;
    JButton close_button = null;
    JButton compiler_browse_button = null;
    private MXJEditCompileContext _ctx = null;
    private CaretListener _error_lineno_dispatch = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            int mark = e.getMark();
            int dot = e.getDot();
            int lineno = -1;
            if (mark != dot) {
                try {
                    ColorPane cp = (ColorPane)e.getSource();
                    lineno = Integer.parseInt(cp.getSelectedText());
                    MXJEditCompileFrame cf = cp.compile_frame;
                    MXJEditCompileContext ctx = cf.getCompileContext();
                    MXJEditor ed = ctx.getEditor();
                    if (!ed.isVisible()) {
                        ed.setVisible(true);
                    } else {
                        ed.toFront();
                    }
                    ed.selectLine(lineno);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
    };

    public MXJEditCompileFrame(MXJEditCompileContext ctx) {
        JPanel p = new JPanel(new SpringLayout());
        JLabel label_sf = new JLabel("Source File:");
        JLabel label_cc = new JLabel("Compiler Command:");
        JLabel label_bd = new JLabel("Build Directory:");
        JLabel label_cp = new JLabel("Classpath:");
        JLabel label_co = new JLabel("Compiler Options:");
        this.tf_sf = new JTextField(30);
        this.tf_sf.setText(ctx.getSourceFile());
        this.tf_sf.setCaretPosition(0);
        this.tf_cc = new JTextField(30);
        this.tf_cc.setText(ctx.getCompileCommand());
        this.tf_cc.setCaretPosition(0);
        this.tf_bd = new JTextField(30);
        this.tf_bd.setText(ctx.getBuildDirectory());
        this.tf_bd.setCaretPosition(0);
        this.tf_cp = new JTextField(30);
        this.tf_cp.setText(ctx.getClassPath());
        this.tf_cp.setCaretPosition(0);
        this.tf_co = new JTextField(30);
        this.tf_co.setCaretPosition(0);
        this._ctx = ctx;
        label_sf.setLabelFor(this.tf_sf);
        label_cc.setLabelFor(this.tf_cc);
        label_bd.setLabelFor(this.tf_bd);
        label_cp.setLabelFor(this.tf_cp);
        label_co.setLabelFor(this.tf_co);
        this.compiler_browse_button = new JButton("Browse...");
        this.compiler_browse_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MXJEditCompileFrame.this.compiler_browse();
            }
        });
        p.add(label_sf);
        p.add(this.tf_sf);
        p.add(Box.createHorizontalStrut(10));
        p.add(label_cc);
        p.add(this.tf_cc);
        p.add(this.compiler_browse_button);
        p.add(label_bd);
        p.add(this.tf_bd);
        p.add(Box.createHorizontalStrut(10));
        p.add(label_cp);
        p.add(this.tf_cp);
        p.add(Box.createHorizontalStrut(10));
        p.add(label_co);
        p.add(this.tf_co);
        p.add(Box.createHorizontalStrut(10));
        p.setBorder(BorderFactory.createEtchedBorder());
        MXJEditCompileFrame.makeCompactGrid(p, 5, 3, 6, 6, 6, 6);
        p.setOpaque(true);
        this.messages = new ColorPane(this);
        this.messages.setEditable(false);
        JScrollPane jsp = new JScrollPane(this.messages);
        JPanel ap = new JPanel();
        this.compile_button = new JButton("Compile");
        this.close_button = new JButton("Close");
        this.compile_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (3.access$100(this.this$1).compile_button.isEnabled()) {
                            3.access$100(this.this$1).compile_button.setEnabled(false);
                        }
                        3.access$100(this.this$1).do_compile();
                        if (!3.access$100(this.this$1).compile_button.isEnabled()) {
                            3.access$100(this.this$1).compile_button.setEnabled(true);
                        }
                    }
                });
                t.start();
            }

            static /* synthetic */ MXJEditCompileFrame access$100(3 x0) {
                return x0.MXJEditCompileFrame.this;
            }
        });
        this.close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MXJEditCompileFrame.this.do_close();
            }
        });
        ap.add(this.compile_button);
        ap.add(this.close_button);
        this.getRootPane().setDefaultButton(this.compile_button);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                int keycode = evt.getKeyCode();
                int mod = evt.getModifiers();
                if (keycode == 87 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    MXJEditCompileFrame.this.setVisible(false);
                    MXJEditCompileFrame.this.dispose();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                int keycode = evt.getKeyCode();
                int mod = evt.getModifiers();
                if (keycode == 69 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    MXJEditor e = MXJEditCompileFrame.this._ctx.getEditor();
                    if (e.isVisible()) {
                        e.toFront();
                    } else {
                        e.setVisible(true);
                    }
                }
            }
        });
        this.getContentPane().add((Component)p, "North");
        this.getContentPane().add((Component)jsp, "Center");
        this.getContentPane().add((Component)ap, "South");
        this.setTitle("MXJ Compile Window");
        this.pack();
        this.setSize(750, 320);
        Dimension dim = this.getToolkit().getScreenSize();
        this.setLocation(dim.width / 4, 50);
        this.setVisible(true);
        this.requestFocus();
    }

    public void setCompileContext(MXJEditCompileContext ctx) {
        this._ctx = ctx;
        if (!this.tf_sf.getText().equals(ctx.getSourceFile())) {
            this.tf_sf.setText(ctx.getSourceFile());
            this.tf_sf.setCaretPosition(0);
        }
        if (!this.tf_cc.getText().equals(ctx.getCompileCommand())) {
            this.tf_cc.setText(ctx.getCompileCommand());
            this.tf_cc.setCaretPosition(0);
        }
        if (!this.tf_bd.getText().equals(ctx.getBuildDirectory())) {
            this.tf_bd.setText(ctx.getBuildDirectory());
            this.tf_bd.setCaretPosition(0);
        }
        if (!this.tf_cp.getText().equals(ctx.getClassPath())) {
            this.tf_cp.setText(ctx.getClassPath());
            this.tf_cp.setCaretPosition(0);
        }
    }

    public MXJEditCompileContext getCompileContext() {
        return this._ctx;
    }

    protected void do_compile() {
        Color ERROR_COLOR = Color.red.darker();
        Color MESSAGE_COLOR = Color.blue.darker();
        Color OK_COLOR = Color.green.darker();
        String sourcefile = this.tf_sf.getText();
        String compiler = this.tf_cc.getText();
        String build_dir = this.tf_bd.getText();
        String classpath = this.tf_cp.getText();
        String options = this.tf_co.getText().trim();
        boolean error = false;
        this.messages.setEditable(true);
        this.messages.setText(null);
        this.setSize(750, 320);
        if (!new File(compiler).exists()) {
            this.messages.append(ERROR_COLOR, "Error: Unable to find java compiler " + compiler);
            error = true;
        } else if (!compiler.equals(this._ctx.getCompileCommand())) {
            MXJPreferences.setMXJCompilerCommmand(compiler);
        }
        if (classpath.equals("") || classpath == null) {
            this.messages.append(ERROR_COLOR, "Error: Classpath must be specified.");
            error = true;
        }
        if (!error) {
            if (this._ctx.getEditor() != null) {
                this._ctx.getEditor().menu_save();
            }
            try {
                this.messages.removeCaretListener(this._error_lineno_dispatch);
                String[] opts = options.trim().split("\\s+");
                String[] cmd = null;
                if (opts.length == 1 && opts[0].equals("")) {
                    cmd = new String[]{compiler, "-classpath", classpath, sourcefile};
                } else {
                    cmd = new String[4 + opts.length];
                    cmd[0] = compiler;
                    for (int i = 1; i < opts.length + 1; ++i) {
                        cmd[i] = opts[i - 1];
                    }
                    cmd[opts.length + 1] = "-classpath";
                    cmd[opts.length + 2] = classpath;
                    cmd[opts.length + 3] = sourcefile;
                }
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmd);
                InputStream stderr = proc.getErrorStream();
                InputStreamReader isr = new InputStreamReader(stderr);
                BufferedReader br = new BufferedReader(isr);
                this.messages.append(MESSAGE_COLOR, "Compiling " + sourcefile + ".........\n\n");
                for (int i = 0; i < cmd.length; ++i) {
                    this.messages.append(MESSAGE_COLOR, cmd[i] + " ");
                }
                this.messages.append(MESSAGE_COLOR, "\n\n");
                String line = null;
                String err_lineno = null;
                String err_msg = null;
                String err_rest_msg = null;
                int err_count = 0;
                int idx = -1;
                while ((line = br.readLine()) != null) {
                    idx = line.indexOf(".java");
                    if (idx != -1) {
                        ++err_count;
                        int first_col = -1;
                        int second_col = -1;
                        first_col = line.indexOf(58, idx);
                        second_col = line.indexOf(58, first_col + 1);
                        if (first_col == -1 || second_col == -1) {
                            this.messages.append(ERROR_COLOR, line + "\n");
                            continue;
                        }
                        err_msg = line.substring(0, first_col);
                        this.messages.append(ERROR_COLOR, err_msg);
                        err_lineno = line.substring(first_col + 1, second_col);
                        this.messages.append(MESSAGE_COLOR, "[ " + err_lineno + " ]", 14);
                        err_rest_msg = line.substring(second_col + 1);
                        this.messages.append(ERROR_COLOR, err_rest_msg + "\n");
                        continue;
                    }
                    line = line.replaceAll("\t", "        ");
                    this.messages.append(ERROR_COLOR, line + "\n");
                }
                String now = DateFormat.getDateTimeInstance().format(new Date());
                int exitVal = proc.waitFor();
                if (exitVal == 0) {
                    this.messages.append(OK_COLOR, "0 errors\n");
                    this.messages.append(OK_COLOR, "[ " + now + " ]\n");
                    this.messages.append(OK_COLOR, " compilation of " + sourcefile + " was successful");
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.setVisible(false);
                    this.dispose();
                } else {
                    int err_scale = 25;
                    this.messages.append(ERROR_COLOR, "[ " + now + " ]\n");
                    this.messages.append(ERROR_COLOR, " compilation of " + sourcefile + " failed.");
                    this.setSize(this.getWidth(), 320 + err_scale * Math.min(8, err_count));
                    this.messages.addCaretListener(this._error_lineno_dispatch);
                }
                proc.destroy();
            }
            catch (Throwable t) {
                this.messages.append(ERROR_COLOR, "Unexpected Error During Compile:\n\n");
                this.messages.append(ERROR_COLOR, "    " + t.getMessage() + "\n\n");
                this.messages.append(ERROR_COLOR, "See Max console for stack trace.\n");
                t.printStackTrace();
            }
        }
        this.messages.setEditable(false);
    }

    private void do_close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, MXJEditCompileFrame.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = MXJEditCompileFrame.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, MXJEditCompileFrame.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = MXJEditCompileFrame.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            this.requestFocus();
            this.getRootPane().setDefaultButton(this.compile_button);
        }
    }

    private void compiler_browse() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileDialog fd = new FileDialog(MXJEditCompileFrame.this);
                fd.setVisible(true);
                String filename = fd.getFile();
                if (filename != null) {
                    MXJEditCompileFrame.this.tf_cc.setText(fd.getDirectory() + filename);
                }
            }
        });
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    class ColorPane
    extends JTextPane {
        public MXJEditCompileFrame compile_frame = null;

        public ColorPane(MXJEditCompileFrame compile_frame_) {
            this.compile_frame = compile_frame_;
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ColorPane this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent evt) {
                    int keycode = evt.getKeyCode();
                    int mod = evt.getModifiers();
                    if (keycode == 87 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        this.this$1.compile_frame.setVisible(false);
                        this.this$1.compile_frame.dispose();
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ColorPane this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent evt) {
                    int keycode = evt.getKeyCode();
                    int mod = evt.getModifiers();
                    if (keycode == 69 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        MXJEditor e = MXJEditCompileFrame.access$300(ColorPane.access$400(this.this$1)).getEditor();
                        if (e.isVisible()) {
                            e.toFront();
                        } else {
                            e.setVisible(true);
                        }
                    }
                }
            });
        }

        public void append(Color c, String s) {
            this.append(c, s, 10);
        }

        public void append(Color c, String s, int fontsize) {
            StyleContext sc = StyleContext.getDefaultStyleContext();
            AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
            aset = sc.addAttribute(aset, StyleConstants.FontFamily, "courier");
            aset = sc.addAttribute(aset, StyleConstants.FontSize, new Integer(fontsize));
            int len = this.getDocument().getLength();
            this.setCaretPosition(len);
            this.setCharacterAttributes(aset, false);
            this.replaceSelection(s);
        }

        static /* synthetic */ MXJEditCompileFrame access$400(ColorPane x0) {
            return x0.MXJEditCompileFrame.this;
        }
    }
}

