/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.max.MaxSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MXJClassLoaderImpl
extends ClassLoader {
    private Vector fPathItems;
    private final HashMap code_resource_map = new HashMap(64);
    private String _extended_search_dir = null;
    private String[] _pruned_search_path = null;
    private static final String SEP = String.valueOf(File.separatorChar);

    public MXJClassLoaderImpl() {
        this.fPathItems = new Vector(16);
    }

    public MXJClassLoaderImpl(Vector classpath) {
        this.fPathItems = new Vector(16);
        for (int i = 0; i < classpath.size(); ++i) {
            this.addDirectory((String)classpath.elementAt(i));
        }
    }

    public MXJClassLoaderImpl(Vector classpath, String extended_search_dir) {
        this.fPathItems = new Vector(16);
        for (int i = 0; i < classpath.size(); ++i) {
            this.addDirectory((String)classpath.elementAt(i));
        }
        this._extended_search_dir = extended_search_dir;
    }

    protected void setExtendedClassSearchDirectory(String dirname) {
        this._extended_search_dir = dirname;
    }

    protected void addDirectory(String dirname) {
        boolean isjar = false;
        if (dirname.endsWith(".jar") || dirname.endsWith(".zip")) {
            isjar = true;
        } else if (dirname.charAt(dirname.length() - 1) != File.separatorChar) {
            dirname = dirname + String.valueOf(File.separatorChar);
        }
        File f = new File(dirname);
        if (f.exists()) {
            if (isjar) {
                try {
                    this.definepackages(new JarFile(dirname));
                }
                catch (IOException e) {
                    System.err.println("(mxj classloader) problems loading dynamic classpath entry." + dirname);
                    e.printStackTrace();
                    return;
                }
            }
            this.fPathItems.addElement(dirname);
        } else {
            System.out.println("(mxj classloader) dynamic classpath entry " + dirname + " does not exist.");
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.doLoadClass(name, resolve, true);
    }

    public synchronized Class doLoadClass(String name, boolean resolve, boolean report_error) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            c = this.findSystemClass(name);
            return c;
        }
        catch (ClassNotFoundException e) {
            if (c == null) {
                Object[] data = this.lookupClassData(name);
                if (data == null) {
                    if (report_error) {
                        System.err.println("(mxj) classloader unable to find " + name);
                    }
                } else {
                    c = this.defineClass(name, (byte[])data[0], 0, ((byte[])data[0]).length, (ProtectionDomain)data[1]);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                }
            }
            return c;
        }
    }

    private Object[] lookupClassData(String className) throws ClassNotFoundException {
        byte[] data = null;
        for (int i = 0; i < this.fPathItems.size(); ++i) {
            String path = (String)this.fPathItems.elementAt(i);
            String fileName = null;
            CodeSource cs = null;
            if (this.isJar(path)) {
                fileName = className.replace('.', '/') + ".class";
                data = this.loadJarData(path, fileName);
            } else {
                fileName = className.replace('.', File.separatorChar) + ".class";
                data = this.loadFileData(path, fileName);
            }
            if (data == null) continue;
            try {
                cs = new CodeSource(new URL("file://" + path), (Certificate[])null);
            }
            catch (MalformedURLException mfe) {
                mfe.printStackTrace();
            }
            ProtectionDomain pd = new ProtectionDomain(cs, null, this, null);
            return new Object[]{data, pd};
        }
        Object[] lastchance = null;
        String repl = className.replace('.', File.separatorChar) + ".class";
        String pd = MaxSystem.getDefaultPath();
        if (pd != null) {
            File f = new File(pd);
            if (!f.exists() || !f.isDirectory()) {
                System.err.println("(mxj classloader) default directory " + pd + " does not seem to exist or is not directory!");
            } else {
                lastchance = this.look_for_class_recursive(pd, repl);
            }
        }
        if (lastchance != null) {
            return lastchance;
        }
        if (this._pruned_search_path == null) {
            this.set_pruned_search_path();
        }
        for (int i = 0; i < this._pruned_search_path.length; ++i) {
            lastchance = this.look_for_class_recursive(this._pruned_search_path[i], repl);
            if (lastchance == null) continue;
            return lastchance;
        }
        throw new ClassNotFoundException(className);
    }

    private void set_pruned_search_path() {
        String[] sp = MaxSystem.getSearchPath();
        String[] candidates = new String[128];
        int cc = 0;
        for (int i = 0; i < sp.length; ++i) {
            String pot = sp[i];
            boolean skip = false;
            for (int ii = 0; ii < cc; ++ii) {
                if (!pot.startsWith(candidates[ii])) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            candidates[cc++] = pot;
        }
        String[] muster = new String[cc];
        System.arraycopy(candidates, 0, muster, 0, cc);
        this._pruned_search_path = muster;
    }

    private Object[] look_for_class_recursive(String dir, String classfile) {
        String currentfile;
        byte[] data = null;
        CodeSource cs = null;
        if (dir == null) {
            return null;
        }
        if (!dir.endsWith(SEP)) {
            dir = dir + SEP;
        }
        if (new File(currentfile = dir + classfile).exists()) {
            data = this.loadFileData(dir, classfile);
            if (data != null) {
                try {
                    cs = new CodeSource(new URL("file://" + dir), (Certificate[])null);
                }
                catch (MalformedURLException mfe) {
                    mfe.printStackTrace();
                }
                ProtectionDomain pd = new ProtectionDomain(cs, null, this, null);
                return new Object[]{data, pd};
            }
            System.err.println("(mxj classloader) unable to load class file bytes from " + currentfile);
            return null;
        }
        String[] fl = new File(dir).list();
        if (fl == null) {
            return null;
        }
        for (int i = 0; i < fl.length; ++i) {
            Object[] ret;
            String f = new String(dir + fl[i]);
            if (f.endsWith(".jar") || f.endsWith(".zip")) {
                String jarname = classfile.replace(File.separatorChar, '/');
                data = this.loadJarData(f, jarname);
                if (data == null) continue;
                try {
                    cs = new CodeSource(new URL("file://" + f), (Certificate[])null);
                }
                catch (MalformedURLException mfe) {
                    mfe.printStackTrace();
                }
                ProtectionDomain pd = new ProtectionDomain(cs, null, this, null);
                return new Object[]{data, pd};
            }
            if (!new File(f).isDirectory() || (ret = this.look_for_class_recursive(f, classfile)) == null) continue;
            return ret;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] look_for_class_extended(String className) {
        void var3_5;
        File f;
        byte[] data = null;
        String fileName = null;
        CodeSource cs = null;
        if (this._extended_search_dir == null || !(f = new File(this._extended_search_dir)).exists() && !f.isDirectory()) {
            return null;
        }
        fileName = className.replace('.', File.separatorChar) + ".class";
        data = this.loadFileData(this._extended_search_dir, fileName);
        if (data != null) {
            try {
                cs = new CodeSource(new URL("file://" + this._extended_search_dir), (Certificate[])null);
            }
            catch (MalformedURLException mfe) {
                mfe.printStackTrace();
            }
            ProtectionDomain pd = new ProtectionDomain(cs, null, this, null);
            return new Object[]{data, pd};
        }
        fileName = className.replace('.', '/') + ".class";
        String[] files = var3_5.list();
        for (int i = 0; i < files.length; ++i) {
            if (!this.isJar(files[i]) || (data = this.loadJarData(this._extended_search_dir + File.separatorChar + files[i], fileName)) == null) continue;
            try {
                cs = new CodeSource(new URL("file://" + this._extended_search_dir + "/" + files[i]), (Certificate[])null);
            }
            catch (MalformedURLException mfe) {
                mfe.printStackTrace();
            }
            ProtectionDomain pd = new ProtectionDomain(cs, null, this, null);
            return new Object[]{data, pd};
        }
        return null;
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    private byte[] getClassData(File file) {
        FileInputStream is = null;
        try {
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                System.err.println(file.getAbsolutePath() + " is too big to be read");
                ((InputStream)is).close();
                return null;
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
            return bytes;
        }
        catch (FileNotFoundException fne) {
            return null;
        }
        catch (IOException e) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            return null;
        }
    }

    private byte[] loadJarData(String path, String fileName) {
        ZipFile zipFile = null;
        InputStream stream = null;
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        int size = (int)entry.getSize();
        try {
            int n;
            stream = zipFile.getInputStream(entry);
            byte[] data = new byte[size];
            for (int pos = 0; pos < size; pos += n) {
                n = stream.read(data, pos, data.length - pos);
            }
            zipFile.close();
            return data;
        }
        catch (IOException ee) {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException eee) {
                // empty catch block
            }
            return null;
        }
    }

    public String[] getCurrentClassPath() {
        String[] ret;
        boolean ext_search;
        boolean bl = ext_search = this._extended_search_dir != null;
        if (ext_search) {
            int size = this.fPathItems.size() + 1;
            ret = new String[size];
            for (int i = 0; i < size - 1; ++i) {
                ret[i] = (String)this.fPathItems.elementAt(i);
            }
            ret[i] = this._extended_search_dir;
        } else {
            int size = this.fPathItems.size();
            ret = new String[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = (String)this.fPathItems.elementAt(i);
            }
        }
        return ret;
    }

    public void dump() {
        String[] s = this.getCurrentClassPath();
        for (int i = 0; i < s.length; ++i) {
            System.out.println("  " + s[i]);
        }
    }

    private void definepackages(JarFile f) {
        try {
            Manifest manifest = f.getManifest();
            if (manifest != null) {
                Map<String, Attributes> entries = manifest.getEntries();
                Iterator<String> i = entries.keySet().iterator();
                while (i.hasNext()) {
                    String path = i.next();
                    if (path.endsWith(".class")) continue;
                    String name = path.replace('/', '.');
                    if (name.endsWith(".")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    this.definePackage(path, name, manifest, null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Package definePackage(String path, String name, Manifest man, URL url) throws IllegalArgumentException {
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    public URL getResource(String name) {
        return this.lookup_resource(name);
    }

    private URL lookup_resource(String rname) {
        URL ret = null;
        ret = ClassLoader.getSystemResource(rname);
        if (ret != null) {
            return ret;
        }
        File f = null;
        ZipFile zipFile = null;
        ZipEntry entry = null;
        for (int i = 0; i < this.fPathItems.size(); ++i) {
            String path = (String)this.fPathItems.elementAt(i);
            if (this.isJar(path)) {
                try {
                    zipFile = new ZipFile(path);
                    entry = zipFile.getEntry(rname);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    continue;
                }
                if (entry == null) continue;
                try {
                    ret = new URL("jar:file:" + path + "!/" + rname);
                }
                catch (MalformedURLException mfue) {
                    mfue.printStackTrace();
                    return null;
                }
                return ret;
            }
            if (!path.endsWith(SEP)) {
                path = path + SEP;
            }
            if (!(f = new File(path + rname)).exists()) continue;
            try {
                ret = f.toURL();
            }
            catch (MalformedURLException mfue) {
                mfue.printStackTrace();
                return null;
            }
            return ret;
        }
        String pd = MaxSystem.getDefaultPath();
        if (pd != null) {
            f = new File(pd);
            if (!f.exists() || !f.isDirectory()) {
                System.err.println("(mxj classloader look for resource) default directory " + pd + " does not seem to exist or is not directory!");
            } else {
                ret = this.look_for_resource_recursive(pd, rname);
            }
        }
        if (ret != null) {
            return ret;
        }
        if (this._pruned_search_path == null) {
            this.set_pruned_search_path();
        }
        for (int i = 0; i < this._pruned_search_path.length; ++i) {
            ret = this.look_for_resource_recursive(this._pruned_search_path[i], rname);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private URL look_for_resource_recursive(String dir, String rname) {
        String currentfile;
        URL ret = null;
        File file = null;
        if (dir == null) {
            return null;
        }
        if (!dir.endsWith(SEP)) {
            dir = dir + SEP;
        }
        if ((file = new File(currentfile = dir + rname)).exists()) {
            try {
                ret = file.toURL();
            }
            catch (MalformedURLException mfue) {
                mfue.printStackTrace();
                return null;
            }
            return ret;
        }
        String[] fl = new File(dir).list();
        if (fl == null) {
            return null;
        }
        ZipFile zipFile = null;
        ZipEntry entry = null;
        for (int i = 0; i < fl.length; ++i) {
            String f = new String(dir + fl[i]);
            if (f.endsWith(".jar") || f.endsWith(".zip")) {
                try {
                    zipFile = new ZipFile(f);
                    entry = zipFile.getEntry(rname);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    continue;
                }
                if (entry == null) continue;
                try {
                    ret = new URL("jar:file:" + f + "!/" + rname);
                }
                catch (MalformedURLException mfue) {
                    mfue.printStackTrace();
                    return null;
                }
                return ret;
            }
            if (!new File(f).isDirectory() || (ret = this.look_for_resource_recursive(f, rname)) == null) continue;
            return ret;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        for (int i = 0; i < this.fPathItems.size(); ++i) {
            String path = (String)this.fPathItems.elementAt(i);
            ZipFile zipFile = null;
            if (this.isJar(path)) {
                try {
                    zipFile = new ZipFile(path);
                    ZipEntry entry = zipFile.getEntry(name);
                    if (entry != null) {
                        return zipFile.getInputStream(entry);
                    }
                }
                catch (IOException io) {
                    System.err.println("(mxj classloader) getResourceAsStream");
                    io.printStackTrace();
                }
                continue;
            }
            File file = new File(path, name);
            if (!file.exists()) continue;
            try {
                return new FileInputStream(file);
            }
            catch (Exception ee) {
                System.err.println("(mxj classloader) getResourceAsStream");
                ee.printStackTrace();
                return null;
            }
        }
        return ClassLoader.getSystemResourceAsStream(name);
    }
}

