
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;

import type.lib.ToolBox;

public class L21App4 {
	public static void main(String[] args) throws IOException {
		PrintStream output = System.out;

		// here we compose the string that represents the particular remote
		// resource in which we are interested
		String theURL = "http://www.cse.yorku.ca/~roumani/jba/ase/se.cgi?hrss=+BB"; // in principle, this could be
											// *any* URL, not only
											// one based on http

		// next we construct an object to encapsulate this particular URL
		URL url = new URL(theURL);

		// use the services of URL to determine the protocol that is associated
		// with this particular remote object
		output.println(url.getProtocol());

		// the connection to and from this remote object is governed by the http
		// protocol
		// use the services of URL to derive the object that encapsulates this
		// connection
		URLConnection connection = url.openConnection();

		// since the protocol is http, the connection will be a specific
		// sub-type of URLConnection: HttpURLConnection
		HttpURLConnection httpConnection = null;

		if (connection instanceof HttpURLConnection) {
			// since the protocol is http, the connection will be a specific
			// sub-type of URLConnection: HttpURLConnection
			httpConnection = (HttpURLConnection) connection;
		} else {
			output.println("We are considering only http protocol in this example.");
			System.exit(0);
		}

		// for http, we have two request methods: get and post; here we can find
		// out which one is used
		output.println(httpConnection.getRequestMethod());
		// for http, once a request is made, the server will issue a response.
		// Here we can find the code of the response and the associated message.
		// (note that this method blocks until the server issues a response)
		output.println(httpConnection.getResponseCode());
		output.println(httpConnection.getResponseMessage());

		boolean isContentFound = HttpURLConnection.HTTP_OK == httpConnection
				.getResponseCode();

		output.println(isContentFound);
		ToolBox.crash(!isContentFound, "No content provided by server.");

		InputStream htmlInputStream = httpConnection.getInputStream();
		String content = "";

		Scanner input = new Scanner(htmlInputStream);
		while (input.hasNext()) {
			String currentLine = input.nextLine();
			// output.println(currentLine);output.println(currentLine);
			content += currentLine;
		}
		output.println(content);
		HTMLTextDisplayer myDisplayer = new HTMLTextDisplayer();
		myDisplayer.display();
		myDisplayer.setContent(content);
	}
}
