

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Scanner;

import type.lib.ToolBox;

public class L21App2 {
	public static void main(String[] args) throws IOException {
		PrintStream output = System.out;

		// here we compose the string that represents the particular remote
		// resource in which we are interested
		String theURL = "ftp://ctan.org"; // in principle, this could be
											// *any* URL, not only
											// one based on http

		// next we construct an object to encapsulate this particular URL
		URL url = new URL(theURL);

		// use the services of URL to determine the protocol that is associated
		// with this particular remote object
		output.println(url.getProtocol());

		// the connection to and from this remote object is governed by the http
		// protocol
		// use the services of URL to derive the object that encapsulates this
		// connection
		URLConnection connection = url.openConnection();

		// use the services of URLConnection to determine the date at which the
		// message originates
		output.println(new Date(connection.getDate()));

		// since the protocol is http, the connection will be a specific
		// sub-type of URLConnection: HttpURLConnection
		HttpURLConnection httpConnection = null;

		// to assign the reference, check that this assignment will not cause a
		// run-time error
		if (connection instanceof HttpURLConnection) {
			// since the protocol is http, the connection will be a specific
			// sub-type of URLConnection: HttpURLConnection
			httpConnection = (HttpURLConnection) connection;
		} else {
			output.println("We are considering only http protocol in this example.");
			System.exit(0);
		}

		// or we could do the following
		ToolBox.crash(!(connection instanceof HttpURLConnection),
				"We are considering only http protocol in this example.");

		output.println(new Date(httpConnection.getDate()));

	}
}
