

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Scanner;

public class L21App1 {
	public static void main(String[] args) throws IOException {
		PrintStream output = System.out;

		// here we compose the string that represents the particular remote
		// resource in which we are interested
		String theURL = "http://ctan.org"; // in principle, this could
												// be
												// *any* URL, not only
												// one based on http


		// next we construct an object to encapsulate this particular URL
		URL url = new URL(theURL);

		// use the services of URL to determine the protocol that is associated
		// with this particular remote object
		output.println(url.getProtocol());

		// the connection to and from this remote object is governed by the http
		// protocol
		// use the services of URL to derive the object that encapsulates this
		// connection
		URLConnection connection = url.openConnection();

		// use the services of URLConnection to determine the date at which the
		// message originates
		output.println(new Date(connection.getDate()));

		// since the protocol is http, the connection will be a specific
		// sub-type of URLConnection: HttpURLConnection
		// Create a variable of this type
		HttpURLConnection httpConnection = null;

		// now assign the variable so that it refers to the URL connection
		// objection (is this risky?)
		httpConnection = (HttpURLConnection) connection;

		// why can't we just do it directly?
		// HttpURLConnection httpConnection = url.openConnection();

		output.println(new Date(httpConnection.getDate()));

	}
}
