/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.handler;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.xpath.ui.internal.XPathUIPlugin;
import org.eclipse.wst.xml.xpath.ui.internal.views.EditNamespacePrefixDialog;

public class PrefixHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        XPathUIPlugin plugin = XPathUIPlugin.getDefault();
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IFile file = (IFile)activeEditor.getEditorInput().getAdapter(IFile.class);
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IDOMModel model = null;
        try {
            try {
                model = (IDOMModel)modelManager.getModelForRead(file);
                IDOMDocument document = model.getDocument();
                if (document != null) {
                    List<NamespaceInfo> info = plugin.getNamespaceInfo(document);
                    IPathEditorInput editorInput = (IPathEditorInput)activeEditor.getEditorInput();
                    EditNamespacePrefixDialog dlg = new EditNamespacePrefixDialog(activeEditor.getSite().getShell(), editorInput.getPath());
                    dlg.setNamespaceInfoList(info);
                    dlg.open();
                }
            }
            catch (Exception exception) {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }
}

