#include "gcd.h"
/*
 * DEFINES
 */
/*
 * GLOBALS AND EXTERNALS
 */
extern int m,n;
//static 
static int rcount;

/*
 * iterative GCD
 */
int gcd_iter(int u, int v)
{  int t;
   while (v)
   {
     assert(v>0);
     t = u;
     u = v;
     v = t % v;
  }
  return u < 0 ? -u : u; /* abs(u) */
}

/*
 * recursive GCD
 */
int gcdr(int m, int n)
{
                /* base case(s) */
                if (m == 0)
                        return(n);
                if (n == 0)
                        return(m);
                /* now recurse */
                return(gcdr(n, m % n));
}


/*
 * This function returns the greatest common divisor of its arguments
 * Notes: BASE CASES:
 *        (1) if m = n = 0, the GCD is undefined -- so we return BAD_GCD
 *        (2) if m < 0 or n < 0, then gcd(m,n) > 0; so we can just make
 *            m and n both positive
 *        (3) if m = 0 and n != 0, gcd(m,n) = n (and vice versa)
 */
 int gcd()
{
                /*
                 * special cases
                 */
                /* error check -- if both 0, undefined */
                if (m == 0 && n == 0)
                        return(BAD_GCD);
                /* make all negatives positive */
                if (m < 0) m = -m;
                if (n < 0) n = -n;
                /*
                 * now apply the recursive algorithm
                 */
                return(gcdr(m, n));
}

