
% ========================================================================
% Copyright(c) 2017 Xianming Liu, Gene Cheung, Xiaolin Wu, Debin Zhao
% All Rights Reserved.
%
% ----------------------------------------------------------------------
% Permission to use, copy, or modify this software and its documentation
% for educational and research purposes only and without fee is hereby
% granted, provided that this copyright notice and the original authors'
% names appear on all copies and supporting documentation. This program
% shall not be used, rewritten, or adapted as the basis of a commercial
% software or hardware product without first obtaining permission of the
% authors. The authors make no representations about the suitability of
% this software for any purpose. It is provided "as is" without express
% or implied warranty.
%----------------------------------------------------------------------
% This is an implementation of mixture of priors for soft decoding of JPEG
% images

% Please refer to the following paper:
%
%Xianming Liu, Gene Cheung, Xiaolin Wu, Debin Zhao, " Random Walk Graph Laplacian based Smoothness
%Prior for Soft Decoding of JPEG Images," IEEE Transactions on Image Processing, Vol. 26, No.2, pp. 782-296, Feb. 2017

%------------------------------------------------------------------------
clear;
clc;

cur = cd;
addpath(genpath(cur));

temp_dir   =    'JPEG';
out_dir    =    'Result';


for qp = [5]
    
    for ImgNo =[1:14]
        
        switch ImgNo
            case 1
                OrgName = 'Gray_Butterfly.tif';
            case 2
                OrgName = 'Leaves256.tif';
            case 3
                OrgName = 'Gray_hat.tif';
            case 4
                OrgName = 'boats.tif';
            case 5
                OrgName = 'Gray_bike.tif';
            case 6
                OrgName = 'house.tif';
            case 7
                OrgName = 'Gray_flower.tif';
            case 8
                OrgName = 'Gray_Parrots.tif';
            case 9
                OrgName = 'Peppers.bmp';
            case 10
                OrgName = 'Fishingboat.bmp';
            case 11
                OrgName = 'Lena.bmp';
            case 12
                OrgName = 'airplane512.png';
            case 13
                OrgName = 'bike512.png';
            case 14
                OrgName = 'statue512.png';
        end
        par.imname   =   OrgName;
        orig_img        =   double( imread(OrgName) );
        
        [par.h, par.w, ch] = size(orig_img);
        out_img  = uint8(zeros(size(orig_img)));
        
        
        par.qp   = qp;
        Qtab    = jpeg_qtable(par.qp);
        
        fname = strcat('compressed_img','_qp',num2str(qp),'.jpg');
        imwrite(orig_img./255,fullfile(temp_dir, fname),'Quality',qp);
        jpg_img = double(imread(fullfile(temp_dir, fname)));
        
        fname  =   strcat('JPEG','_qp',num2str(qp),'_PSNR',num2str(csnr(jpg_img, orig_img, 0,0)), '_SSIM',num2str(cal_ssim(jpg_img, orig_img, 0, 0)),'_',OrgName);
        imwrite(jpg_img./255, fullfile(temp_dir, fname));
        
        fprintf( 'Image = %s, QP = %d, JPEG-PSNR =  %f\n', OrgName, qp,csnr(jpg_img, orig_img, 0,0));
        
        %----------------------------------------------------------------
        
        
        if ch == 3
            im_orig    =   rgb2ycbcr( uint8(orig_img) );
            im_jpg     =   rgb2ycbcr( uint8(jpg_img) );
        else
            im_orig = orig_img;
            im_jpg  = jpg_img;
        end
        
        par = Parameter_setting(par);
        
        par.lambda = 10; %% regularization parameter
        
        for ii = 1:ch
            
            jpg_im   = double(im_jpg(:,:,ii));
            orig_im = double(im_orig(:,:,ii));
            par.orig = orig_im;
            par.cimg = jpg_im;
            
            if ii == 1
                t0 = cputime;
                [out_im,par]  = SparseGraphEstimation(jpg_im, jpg_im,par);
                fprintf( 'Image = %s, QP = %d, Our-PSNR =  %f, Our-SSIM =  %f\n', OrgName, qp,csnr(out_im, orig_im, 5,5),cal_ssim(out_im, orig_im, 5,5));
                
                
                t1 = cputime - t0;
                out_img(:,:,ii)  =  uint8(out_im);
                
                fname  =   strcat(OrgName, '_all','_qp',num2str(qp),'_lambda',num2str(par.lambda),'_PSNR_',num2str(csnr(out_im,orig_im,5,5)), '_SSIM',num2str(cal_ssim(out_im,orig_img,5,5)),'_time',num2str(t1),'_.tif');
                imwrite(out_im./255, fullfile(out_dir, fname));
            end
            
        end
        
        
    end
end