function [ImgRec] = DCT_Alone_estimation(jpg_im,par)


S   =  par.dctstep/2;
[Hight Width]   =   size(jpg_im);
SearchWin = par.SearchWin;
PatchSize    =    par.patchsize;
PatchSize2    =   PatchSize*PatchSize;
ArrayNo   =   30;

if par.qp ==5 
   par.svd = 6;
elseif par.qp == 15
   par.svd = 8;
else
   par.svd = 10;
end

Qtab    = jpeg_qtable(par.qp);

N     =  Hight-PatchSize+1;
M     =  Width-PatchSize+1;
L     =  N*M;

Row     =  [1:S:N];
Row     =  [Row Row(end)+1:N];
Col     =  [1:S:M];
Col    =  [Col Col(end)+1:M];

PatchSet     =  zeros(PatchSize2, L, 'single');

Count     =  0;
for i = 1:N
    for j = 1:M
        Count    =  Count+1;
        Patch  =  jpg_im(i:i+PatchSize-1,j:j+PatchSize-1);
        DCTPatch = dct2(Patch);
        PatchSet(:,Count) = DCTPatch(:);
    end
end

PatchSetT = PatchSet';

I        =   (1:L);
I        =   reshape(I, N, M);
NN       =   length(Row);
MM       =   length(Col);

ImgTemp     =  zeros(Hight, Width);
ImgWeight   =  zeros(Hight, Width);
PatchArray  =  zeros(PatchSize, PatchSize, ArrayNo);

%tic;

for  i  =  1 : NN
    for  j  =  1 : MM
        
        CurRow      =   Row(i);
        CurCol      =   Col(j);
        Off      =   (CurCol-1)*N + CurRow;
        
        CurPatchIndx  =  PatchSearch(PatchSetT, CurRow, CurCol, Off, ArrayNo, SearchWin, I);
        CurPatchIndx(1) = Off;
        %IndcMatrix(i,j,:) = CurPatchIndx;
        
        CurArray = PatchSet(:, CurPatchIndx);       
        
        [SG_S SG_V SG_D] = svd(CurArray);
        
        
        SG_Z = SG_V.*(abs(SG_V)>SG_V(par.svd,par.svd));
        CurArray = SG_S*SG_Z*SG_D';
        
        
        for k = 1:ArrayNo
            PatchArray(:,:,k) = reshape(CurArray(:,k),PatchSize,PatchSize);
        end
               
        for k = 1:length(CurPatchIndx)
            RowIndx  =  ComputeRowNo((CurPatchIndx(k)), N);
            ColIndx  =  ComputeColNo((CurPatchIndx(k)), N);
            
            RecDCTPatch = PatchArray(:,:,k)';
            RecPixelPatch = idct2(RecDCTPatch);
            ImgTemp(RowIndx:RowIndx+PatchSize-1, ColIndx:ColIndx+PatchSize-1)    =   ImgTemp(RowIndx:RowIndx+PatchSize-1, ColIndx:ColIndx+PatchSize-1) + RecPixelPatch;
            ImgWeight(RowIndx:RowIndx+PatchSize-1, ColIndx:ColIndx+PatchSize-1)  =   ImgWeight(RowIndx:RowIndx+PatchSize-1, ColIndx:ColIndx+PatchSize-1) + 1;
        end
        
    end
end
ImgRec = ImgTemp./(ImgWeight+eps);
ImgRec = ImgRec';
ImgRec = Quan_clipping(ImgRec,jpg_im, Qtab,0.3);
% %--------------clipping-------------------
%       for ii = 1 : 8 : Hight
%         for jj = 1 : 8 : Width
%             b = jpg_im(ii:ii+7,jj:jj+7);
%             bt=dct2(b);
%             brect=ImgDCTRec(ii:ii+7,jj:jj+7);
%             te=min(brect,bt+0.3*qt);
%             te=max(te,bt-0.3*qt);
%             ImgRec(ii:ii+7,jj:jj+7)=idct2(te);
%         end
%      end
% %save ('IndcMatrix.mat', 'IndcMatrix');
% 
% %toc;

return;
function row_no = ComputeRowNo(block_no,height)

if mod(block_no,height) == 0
    row_no = height;
else 
    row_no = mod(block_no,height);
end

function col_no = ComputeColNo(block_no,wideth)

 col_no = ceil(double(block_no)/wideth);

