function [out_img,par]  = SparseGraphEstimation( jpg_im, init_im,par )


ori_im = par.orig;
v    =   par.nSig;

Qtab    = jpeg_qtable(par.qp);

load Lib/DicPixel_TD3_p10_c500;
par.PCA_D     =   PCA_D;
par.Codeword  =   centroids;

rec_im        =   init_im;

padsize = par.patchsize - 8;
rec_im = padarray(rec_im,[padsize padsize],'symmetric');
[h,w]  = size(rec_im);


for k = 1:par.K
    
    [PCA_D, D0, cls_idx, s_idx, seg]    =   Set_PCA_idx( rec_im, par, par.Codeword, flag );
    [blk_arr,wei_arr]    =    find_blks( rec_im, par );
    
   
    for i  =  1 : par.iter1
        
        dif     =   rec_im(padsize+1:h-padsize,padsize+1:w-padsize) - jpg_im;
        vd      =   v^2-(mean(mean(dif.^2)));
        par.nSig  = sqrt(abs(vd))*0.8;
        
        rec_im = SparsitySoftDecoding( rec_im, par,PCA_D,cls_idx, s_idx,seg,D0,blk_arr, wei_arr );
        
        rec_im     =   Quan_clipping(rec_im(padsize+1:h-padsize,padsize+1:w-padsize),jpg_im, Qtab,0.3);
        rec_im = padarray(rec_im,[padsize padsize],'symmetric');
    end
    
    graph_init = rec_im;
    
    if k<par.K
        lambda = par.lambda;
        rec_im = BlockLaplcian(rec_im,graph_init,lambda,par);
        fprintf( 'Iter %d : PSNR = %f, SSIM = %f, lambda = %f\n', k,  csnr( rec_im(padsize+1:h-padsize,padsize+1:w-padsize), ori_im,5,5 ),cal_ssim(rec_im(padsize+1:h-padsize,padsize+1:w-padsize), ori_im, 5, 5 ),lambda);
    end
    
end

out_img = rec_im(padsize+1:h-padsize,padsize+1:w-padsize);



