function par = Parameter_setting( par )

Sigma_rec_set = [ 12.8665,9.6726,8.2681,7.4248,6.8237,6.3655,6.0042, 5.7334,5.4781,5.2677,5.0659,4.8481, 4.6096,4.346, 4.0676,3.7075,3.2632,2.6335,1.6705,0.3008];
par.nSig = Sigma_rec_set(par.qp/5);

% if par.qp == 5
par.SearchWin = 30;
par.reg       =   0.02;
par.patchsize = 10;
par.psf       = fspecial('gauss', par.patchsize, 1.5);
par.dctstep  =  8;
par.step      = 2;
par.iter      = 5;
par.ArrayNo  = 60;
par.hp = 150;
par.DCTIterNums = 1;
par.svd = 6;
par.eps       =   2e-6;
par.Threshold = 160;
if par.qp <30
    par.K      =  3;
    par.iter1 = 10;
    par.iter2 = 5;
    par.flag = 1;
    par.step      = 2;
elseif par.qp <50
    par.K      =  2;
    par.iter1 = 15;
    par.iter2 = 4;
    par.flag = 0;
    par.step      = 4;
else
    par.K      =  2;
    par.iter1 = 15;
    par.iter2 = 2;
    par.flag = 0;
    par.step      = 4;
end

if par.h>256
    par.K      =  3;
    par.iter1 = 10;
    par.iter2 = 5;
    par.flag = 0;
end

par.tau1    =   0.1;
par.sigma   =   1.5;
par.nblk    =  40;
par.delta   =   4.5;
par.hp      =   max(12*par.nSig,95);
par.c1      =   0.64;


par.Threshold = 160;
par.lamada    =   0.26;
end

