function img_out_LL = BlockLaplcian(image,init_img,lambda,par)

img_out_LL = zeros(size(image));%% LR*D^{-1}*LR^T
cnt_matrix = zeros(size(image));

[h,w]  = size(image);
b_size = 10;
step   = par.step;
num  = b_size*b_size*b_size*b_size;



cnt  = 0;
count = 1;
for row = 1:step:h-b_size+1
    for col = 1:step:w-b_size+1
        %% patch
        subimg = image(row:row+b_size-1,col:col+b_size-1);
        init_subimg = init_img(row:row+b_size-1,col:col+b_size-1);
        count = count + 1;

        %% compute edge weight
        A = init_subimg(:)';
        Dist  = EuDist2(A');   
        sigma =  sum(Dist(:))./num+eps;       
        W = exp(-0.5*(Dist.^2)/sigma);clear EXlm; % original weights
        W = W - diag(diag(W));
        %% compute graph Laplacain
         LL = Laplacian_compute( W ); % original Lap

        %% LR*D^{-1}*LR'
        reg_LL = eye(length(LL))+lambda*LL;
        region_out = round(reg_LL\subimg(:));
        region_out_LL = reshape(region_out,b_size,b_size);

        %% averaging
        img_out_LL(row:row+b_size-1,col:col+b_size-1) = img_out_LL(row:row+b_size-1,col:col+b_size-1) + region_out_LL;
        cnt_matrix(row:row+b_size-1,col:col+b_size-1) = cnt_matrix(row:row+b_size-1,col:col+b_size-1) + 1;
        
    end
end
% fprintf('percent = %f', cnt/count);
img_out_LL = img_out_LL./cnt_matrix;